/*
 * Decompiled with CFR 0.152.
 */
package coil3.decode;

import coil3.decode.ImageSource;
import coil3.util.UtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcoil3/decode/FileImageSource;", "Lcoil3/decode/ImageSource;", "file", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "diskCacheKey", "", "closeable", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "metadata", "Lcoil3/decode/ImageSource$Metadata;", "<init>", "(Lokio/Path;Lokio/FileSystem;Ljava/lang/String;Ljava/lang/AutoCloseable;Lcoil3/decode/ImageSource$Metadata;)V", "getFile$coil_core", "()Lokio/Path;", "getFileSystem", "()Lokio/FileSystem;", "getDiskCacheKey$coil_core", "()Ljava/lang/String;", "getMetadata", "()Lcoil3/decode/ImageSource$Metadata;", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "isClosed", "", "source", "Lokio/BufferedSource;", "sourceOrNull", "fileOrNull", "close", "", "assertNotClosed", "coil-core"})
@SourceDebugExtension(value={"SMAP\nImageSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageSource.kt\ncoil3/decode/FileImageSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class FileImageSource
implements ImageSource {
    @NotNull
    private final Path file;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final String diskCacheKey;
    @Nullable
    private final AutoCloseable closeable;
    @Nullable
    private final ImageSource.Metadata metadata;
    @NotNull
    private final Object lock;
    private boolean isClosed;
    @Nullable
    private BufferedSource source;

    public FileImageSource(@NotNull Path file, @NotNull FileSystem fileSystem2, @Nullable String diskCacheKey, @Nullable AutoCloseable closeable, @Nullable ImageSource.Metadata metadata) {
        this.file = file;
        this.fileSystem = fileSystem2;
        this.diskCacheKey = diskCacheKey;
        this.closeable = closeable;
        this.metadata = metadata;
        this.lock = new Object();
    }

    @NotNull
    public final Path getFile$coil_core() {
        return this.file;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Nullable
    public final String getDiskCacheKey$coil_core() {
        return this.diskCacheKey;
    }

    @Override
    @Nullable
    public ImageSource.Metadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public BufferedSource source() {
        Object object = this.lock;
        synchronized (object) {
            BufferedSource bufferedSource;
            block4: {
                boolean bl = false;
                this.assertNotClosed();
                BufferedSource bufferedSource2 = this.source;
                if (bufferedSource2 == null) break block4;
                BufferedSource it = bufferedSource2;
                boolean bl2 = false;
                BufferedSource bufferedSource3 = it;
                return bufferedSource3;
            }
            BufferedSource it = bufferedSource = Okio.buffer(this.getFileSystem().source(this.file));
            boolean bl = false;
            this.source = it;
            BufferedSource bufferedSource4 = bufferedSource;
            return bufferedSource4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public BufferedSource sourceOrNull() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.assertNotClosed();
            BufferedSource bufferedSource = this.source;
            return bufferedSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Path file() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.assertNotClosed();
            Path path = this.file;
            return path;
        }
    }

    @Override
    @NotNull
    public Path fileOrNull() {
        return this.file();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.isClosed = true;
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                UtilsKt.closeQuietly(bufferedSource);
            }
            AutoCloseable autoCloseable = this.closeable;
            if (autoCloseable != null) {
                UtilsKt.closeQuietly(autoCloseable);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void assertNotClosed() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
    }
}

