/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.InplaceRefactoringContinuation;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.RenamerFactory;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/StartInlineRenameCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nStartInlineRenameCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartInlineRenameCommand.kt\ncom/jetbrains/performancePlugin/commands/StartInlineRenameCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,79:1\n1374#2:80\n1460#2,5:81\n27#3:86\n87#3,2:87\n28#3,3:89\n98#3:92\n90#3,6:93\n*S KotlinDebug\n*F\n+ 1 StartInlineRenameCommand.kt\ncom/jetbrains/performancePlugin/commands/StartInlineRenameCommand\n*L\n53#1:80\n53#1:81,5\n68#1:86\n68#1:87,2\n68#1:89,3\n68#1:92\n68#1:93,6\n*E\n"})
public final class StartInlineRenameCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SPAN_NAME = "startInlineRename";
    @NotNull
    public static final String PREFIX = "%startInlineRename";

    public StartInlineRenameCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        UndoManagerImpl.ourNeverAskUser = true;
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> StartInlineRenameCommand._execute$lambda$0(actionCallback, project2)));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void _execute$lambda$0(ActionCallbackProfilerStopper $actionCallback, Project $project) {
        void $this$flatMapTo$iv$iv;
        Component focusedComponent = IdeFocusManager.findInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusedComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Editor editor = (Editor)dataContext2.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            $actionCallback.reject("Editor is not focused");
            return;
        }
        if (InplaceRefactoringContinuation.tryResumeInplaceContinuation((Project)$project, (Editor)editor, RenameElementAction.class)) {
            $actionCallback.reject("Another refactoring is in progress");
            return;
        }
        if (!PsiDocumentManager.getInstance((Project)$project).commitAllDocumentsUnderProgress()) {
            $actionCallback.reject("Can't commit documents");
            return;
        }
        Iterable $this$flatMap$iv = RenamerFactory.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RenamerFactory factory = (RenamerFactory)element$iv$iv;
            boolean bl = false;
            Collection collection = factory.createRenamers(dataContext2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"createRenamers(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List renamers = (List)destination$iv$iv;
        if (renamers.isEmpty()) {
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext2);
            int offset = editor.getCaretModel().getOffset();
            Caret caret = (Caret)CommonDataKeys.CARET.getData(dataContext2);
            int caret2 = caret != null ? caret.getOffset() : offset;
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
            TargetElementUtil util = TargetElementUtil.getInstance();
            PsiElement targetElement = util.findTargetElement(editor, util.getReferenceSearchFlags(), caret2);
            PsiFile psiFile = file;
            Object object = psiFile != null ? psiFile.findElementAt(offset) : null;
            String string = editor.getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string.substring(offset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            v7 = $actionCallback.reject("Renamers are empty for element: " + element + ", file: " + file + ", offset: " + offset + ", caret: " + caret2 + ", elementAtOffset: " + object + ", targetElement: " + targetElement + ", text: " + string2);
        } else if (renamers.size() == 1) {
            SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder(SPAN_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder $this$use$iv = spanBuilder;
            boolean $i$f$use = false;
            Span span = $this$use$iv.startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
            Span $this$useWithoutActiveScope$iv$iv = span;
            boolean $i$f$useWithoutActiveScope = false;
            try {
                Unit unit;
                Span span$iv = $this$useWithoutActiveScope$iv$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
                Throwable throwable = null;
                try {
                    Scope it$iv = (Scope)autoCloseable;
                    boolean bl2 = false;
                    Span it = span$iv;
                    boolean bl3 = false;
                    ((Renamer)renamers.get(0)).performRename();
                    $actionCallback.setDone();
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Unit unit2 = unit;
            }
            catch (CancellationException e$iv$iv) {
                throw e$iv$iv;
            }
            catch (Throwable e$iv$iv) {
                $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv;
            }
            finally {
                $this$useWithoutActiveScope$iv$iv.end();
            }
            v7 = Unit.INSTANCE;
        } else {
            v7 = $actionCallback.reject("There are too many renamers");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/StartInlineRenameCommand$Companion;", "", "<init>", "()V", "SPAN_NAME", "", "PREFIX", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

