/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DummyCoverageLoadErrorReporter;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.JavaCoverageClassesEnumerator;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.target.java.JavaTargetParameter;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jacoco.agent.AgentJar;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JaCoCoCoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance(JaCoCoCoverageRunner.class);

    @NotNull
    public CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        if (sessionDataFile == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(0);
        }
        if (reporter == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(1);
        }
        ProjectData data = new ProjectData();
        try {
            Project project;
            Project project2 = project = baseCoverageSuite instanceof BaseCoverageSuite ? baseCoverageSuite.getProject() : null;
            if (project != null) {
                RunConfigurationBase configuration = ((BaseCoverageSuite)baseCoverageSuite).getConfiguration();
                Module mainModule = configuration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule() : null;
                JaCoCoCoverageRunner.loadExecutionData(sessionDataFile, data, mainModule, project, baseCoverageSuite, reporter);
            }
        }
        catch (IOException e) {
            JaCoCoCoverageRunner.processError(sessionDataFile, e, reporter);
            return new FailedCoverageLoadingResult((Exception)e, true, data);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.error((Throwable)e);
            return new FailedCoverageLoadingResult(e, false, data);
        }
        return new SuccessCoverageLoadingResult(data);
    }

    private static void processError(@NotNull File sessionDataFile, IOException e, @NotNull CoverageLoadErrorReporter reporter) {
        if (sessionDataFile == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(2);
        }
        if (reporter == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(3);
        }
        String path = sessionDataFile.getAbsolutePath();
        if ("Invalid execution data file.".equals(e.getMessage())) {
            Notifications.Bus.notify((Notification)new Notification("Coverage", CoverageBundle.message((String)"coverage.error.loading.report", (Object[])new Object[0]), JavaCoverageBundle.message("coverage.error.jacoco.report.format", path), NotificationType.ERROR));
            LOG.info((Throwable)e);
            String message = CoverageBundle.message((String)"coverage.error.loading.report", (Object[])new Object[0]) + ": " + JavaCoverageBundle.message("coverage.error.jacoco.report.format", path);
            reporter.reportWarning(message, (Exception)e);
        } else if (e.getMessage() != null && e.getMessage().startsWith("Unknown block type")) {
            Notifications.Bus.notify((Notification)new Notification("Coverage", CoverageBundle.message((String)"coverage.error.loading.report", (Object[])new Object[0]), JavaCoverageBundle.message("coverage.error.jacoco.report.corrupted", path), NotificationType.ERROR));
            LOG.info((Throwable)e);
            String message = CoverageBundle.message((String)"coverage.error.loading.report", (Object[])new Object[0]) + ": " + JavaCoverageBundle.message("coverage.error.jacoco.report.corrupted", path);
            reporter.reportWarning(message, (Exception)e);
        } else {
            LOG.error((Throwable)e);
            reporter.reportError((Exception)e);
        }
    }

    private static void loadExecutionData(@NotNull File sessionDataFile, ProjectData data, @Nullable Module mainModule, @NotNull Project project, CoverageSuite suite, @NotNull CoverageLoadErrorReporter reporter) throws IOException {
        if (sessionDataFile == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(5);
        }
        if (reporter == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(6);
        }
        ExecFileLoader loader = new ExecFileLoader();
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        JaCoCoCoverageRunner.loadReportToCoverageBuilder(coverageBuilder, sessionDataFile, mainModule, project, loader, (JavaCoverageSuite)suite, reporter);
        for (IClassCoverage classCoverage : coverageBuilder.getClasses()) {
            String className = AnalysisUtils.internalNameToFqn(classCoverage.getName());
            ClassData classData = data.getOrCreateClassData(className);
            Collection methods = classCoverage.getMethods();
            LineData[] lines = new LineData[classCoverage.getLastLine() + 1];
            for (IMethodCoverage method : methods) {
                String desc = method.getName() + method.getDesc();
                int firstLine = method.getFirstLine();
                int lastLine = method.getLastLine();
                for (int i = firstLine; i <= lastLine; ++i) {
                    ILine methodLine = method.getLine(i);
                    int methodLineStatus = methodLine.getStatus();
                    if (methodLineStatus == 0) continue;
                    LineData lineData = new LineData(i, desc);
                    switch (methodLineStatus) {
                        case 2: {
                            lineData.setStatus((byte)2);
                            break;
                        }
                        case 3: {
                            lineData.setStatus((byte)1);
                            break;
                        }
                        default: {
                            lineData.setStatus((byte)0);
                        }
                    }
                    lineData.setHits(methodLineStatus == 2 || methodLineStatus == 3 ? 1 : 0);
                    ICounter branchCounter = methodLine.getBranchCounter();
                    if (branchCounter.getTotalCount() > 0) {
                        int[] keys = new int[branchCounter.getTotalCount()];
                        for (int key = 0; key < keys.length; ++key) {
                            keys[key] = key;
                        }
                        SwitchData switchData = lineData.addSwitch(0, keys);
                        int[] hits = switchData.getHits();
                        Arrays.fill(hits, 0, branchCounter.getCoveredCount(), 1);
                        switchData.setKeysAndHits(keys, hits);
                        switchData.setDefaultHits(1);
                    }
                    classData.registerMethodSignature(lineData);
                    lineData.fillArrays();
                    lines[i] = lineData;
                }
            }
            classData.setLines(lines);
        }
    }

    private static void loadReportToCoverageBuilder(@NotNull CoverageBuilder coverageBuilder, @NotNull File sessionDataFile, @Nullable Module mainModule, @NotNull Project project, ExecFileLoader loader, final JavaCoverageSuite suite, final @NotNull CoverageLoadErrorReporter reporter) throws IOException {
        if (coverageBuilder == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(7);
        }
        if (sessionDataFile == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(8);
        }
        if (project == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(9);
        }
        if (reporter == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(10);
        }
        loader.load(sessionDataFile);
        final Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
        Module[] modules = JaCoCoCoverageRunner.getModules(mainModule, project);
        if (modules.length == 0) {
            String message = "Could not find modules in project, the coverage data will not be loaded";
            LOG.warn(message);
            reporter.reportWarning(message, null);
        }
        CoverageDataManager manager = CoverageDataManager.getInstance((Project)project);
        for (Module module : modules) {
            VirtualFile[] roots = JavaCoverageClassesEnumerator.getRoots(manager, module, true);
            if (roots.length == 0) {
                String message = "Could not find source roots for module " + module.getName() + ", the coverage data will not be loaded";
                LOG.warn(message);
                reporter.reportWarning(message, null);
                continue;
            }
            for (VirtualFile root : roots) {
                try {
                    final Path rootPath = Paths.get(new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)root.getUrl()))).toURI());
                    Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            String internalName = StringUtil.trimEnd((String)rootPath.relativize(path).toString(), (String)".class");
                            String fqn = AnalysisUtils.internalNameToFqn(internalName);
                            if (!suite.isClassFiltered(fqn)) {
                                return FileVisitResult.CONTINUE;
                            }
                            File file = path.toFile();
                            try {
                                analyzer.analyzeAll(file);
                            }
                            catch (Exception e) {
                                LOG.info((Throwable)e);
                                reporter.reportWarning(e);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (NoSuchFileException e) {
                    LOG.warn((Throwable)e);
                    reporter.reportWarning((Exception)e);
                }
            }
        }
    }

    private static Module[] getModules(@Nullable Module mainModule, @NotNull Project project) {
        Module[] modules;
        if (project == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(11);
        }
        if (mainModule != null) {
            HashSet mainModuleWithDependencies = new HashSet();
            ReadAction.run(() -> ModuleUtilCore.getDependencies((Module)mainModule, (Set)mainModuleWithDependencies));
            modules = mainModuleWithDependencies.toArray(Module.EMPTY_ARRAY);
        } else {
            modules = ModuleManager.getInstance((Project)project).getModules();
        }
        return modules;
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, SimpleJavaParameters parameters, boolean testTracking, boolean branchCoverage) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, null, parameters, testTracking, branchCoverage, null, null);
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns, SimpleJavaParameters javaParameters, boolean testTracking, boolean branchCoverage, String sourceMapPath, @Nullable Project project) {
        String path;
        try {
            path = AgentJar.extractToTempLocation().getAbsolutePath();
        }
        catch (IOException e) {
            return;
        }
        String agentPath = JaCoCoCoverageRunner.handleSpacesInAgentPath(path);
        if (agentPath == null) {
            return;
        }
        javaParameters.getTargetDependentParameters().asTargetParameters().add(request -> this.createArgumentTargetValue(agentPath, sessionDataFilePath, patterns, excludePatterns));
    }

    public JavaTargetParameter createArgumentTargetValue(String agentPath, String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns) {
        HashSet uploadPaths = ContainerUtil.newHashSet((Object[])new String[]{agentPath});
        HashSet downloadPaths = ContainerUtil.newHashSet((Object[])new String[]{sessionDataFilePath});
        JavaTargetParameter.Builder builder = new JavaTargetParameter.Builder((Set)uploadPaths, (Set)downloadPaths);
        return JaCoCoCoverageRunner.doCreateCoverageArgument(builder, patterns, excludePatterns, sessionDataFilePath, agentPath);
    }

    @NotNull
    private static JavaTargetParameter doCreateCoverageArgument(@NotNull JavaTargetParameter.Builder builder, String @Nullable [] patterns, String[] excludePatterns, String sessionDataFilePath, String agentPath) {
        if (builder == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(12);
        }
        builder.fixed("-javaagent:").resolved(agentPath).fixed("=destfile=").resolved(sessionDataFilePath).fixed(",append=false");
        if (!ArrayUtil.isEmpty((Object[])patterns)) {
            builder.fixed(",includes=").fixed(StringUtil.join((String[])patterns, (String)":"));
        }
        if (!ArrayUtil.isEmpty((Object[])excludePatterns)) {
            builder.fixed(",excludes=").fixed(StringUtil.join((String[])excludePatterns, (String)":"));
        }
        JavaTargetParameter javaTargetParameter = builder.build();
        if (javaTargetParameter == null) {
            JaCoCoCoverageRunner.$$$reportNull$$$0(13);
        }
        return javaTargetParameter;
    }

    @Override
    public boolean isBranchInfoAvailable(boolean branchCoverage) {
        return true;
    }

    @Override
    public void generateReport(CoverageSuitesBundle suite, Project project) throws IOException {
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        File targetDirectory = new File(settings.OUTPUT_DIRECTORY);
        RunConfigurationBase runConfiguration = suite.getRunConfiguration();
        Module module = runConfiguration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)runConfiguration).getConfigurationModule().getModule() : null;
        ExecFileLoader loader = new ExecFileLoader();
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        for (CoverageSuite aSuite : suite.getSuites()) {
            File coverageFile = new File(aSuite.getCoverageDataFileName());
            try {
                JaCoCoCoverageRunner.loadReportToCoverageBuilder(coverageBuilder, coverageFile, module, project, loader, (JavaCoverageSuite)suite.getSuites()[0], (CoverageLoadErrorReporter)new DummyCoverageLoadErrorReporter());
            }
            catch (IOException e) {
                JaCoCoCoverageRunner.processError(coverageFile, e, (CoverageLoadErrorReporter)new DummyCoverageLoadErrorReporter());
            }
        }
        IBundleCoverage bundleCoverage = coverageBuilder.getBundle(suite.getPresentableName());
        IReportVisitor visitor = new HTMLFormatter().createVisitor((IMultiReportOutput)new FileMultiReportOutput(targetDirectory));
        visitor.visitInfo(loader.getSessionInfoStore().getInfos(), loader.getExecutionDataStore().getContents());
        int tabWidth = 4;
        MultiSourceFileLocator multiSourceFileLocator = new MultiSourceFileLocator(tabWidth);
        for (Module srcModule : JaCoCoCoverageRunner.getModules(module, project)) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)srcModule).getSourceRoots(true)) {
                multiSourceFileLocator.add((ISourceFileLocator)new DirectorySourceFileLocator(VfsUtilCore.virtualToIoFile((VirtualFile)root), StandardCharsets.UTF_8.name(), tabWidth));
            }
        }
        visitor.visitBundle(bundleCoverage, (ISourceFileLocator)multiSourceFileLocator);
        visitor.visitEnd();
    }

    @NotNull
    public String getPresentableName() {
        return "JaCoCo";
    }

    @NotNull
    public String getId() {
        return "jacoco";
    }

    @NotNull
    public String getDataFileExtension() {
        return "exec";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageBuilder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JaCoCoCoverageRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JaCoCoCoverageRunner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateCoverageArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processError";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadExecutionData";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadReportToCoverageBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCreateCoverageArgument";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

