/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.FieldImpl;
import com.jetbrains.sa.jdi.JvmUtils;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.ThreadReferenceImpl;
import com.jetbrains.sa.jdi.ValueImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import com.jetbrains.sa.jdwp.PacketStream;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.Mark;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.MonitorInfo;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.utilities.Assert;

public class ObjectReferenceImpl
extends ValueImpl {
    protected final ReferenceTypeImpl referenceType;
    private final Oop saObject;
    private boolean monitorInfoCached = false;
    private ThreadReferenceImpl owningThread = null;
    private List<ThreadReferenceImpl> waitingThreads = null;
    private int entryCount = 0;

    ObjectReferenceImpl(ReferenceTypeImpl type, Oop oRef) {
        this.referenceType = type;
        this.saObject = oRef;
    }

    protected Oop ref() {
        return this.saObject;
    }

    VirtualMachineImpl vm() {
        return this.referenceType.vm;
    }

    public ReferenceTypeImpl referenceType() {
        return this.referenceType;
    }

    protected void visitReferences(HandleVisitor visitor) {
        ReferenceTypeImpl referenceType = this.referenceType();
        Instance typeMirror = referenceType.getJavaMirror();
        for (FieldImpl field : referenceType.allFields()) {
            OopHandle valueHandle;
            if (!field.ref().getFieldType().isOop() || (valueHandle = ((OopField)field.ref()).getValueAsOopHandle((Oop)(field.isStatic() ? typeMirror : this.saObject))) == null || !visitor.visit(valueHandle)) continue;
            return;
        }
    }

    public ValueImpl getValue(FieldImpl field) {
        if (field.isStatic()) {
            return this.referenceType.getValue(field);
        }
        this.referenceType.validateFieldAccess(field);
        return field.getValue(this.saObject);
    }

    static long uniqueID(OopHandle handle, VirtualMachineImpl vm) {
        return vm.getAddressValue((Address)handle);
    }

    public long uniqueID() {
        return ObjectReferenceImpl.uniqueID(this.saObject.getHandle(), this.vm());
    }

    public List<ThreadReferenceImpl> waitingThreads() {
        if (!this.vm().canGetMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (!this.monitorInfoCached) {
            this.computeMonitorInfo();
        }
        return this.waitingThreads;
    }

    public ThreadReferenceImpl owningThread() {
        if (!this.vm().canGetMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (!this.monitorInfoCached) {
            this.computeMonitorInfo();
        }
        return this.owningThread;
    }

    public int entryCount() {
        if (!this.vm().canGetMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        if (!this.monitorInfoCached) {
            this.computeMonitorInfo();
        }
        return this.entryCount;
    }

    public List<ObjectReferenceImpl> referringObjects(long maxReferrers) {
        if (!this.vm().canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        if (maxReferrers < 0L) {
            throw new IllegalArgumentException("maxReferrers is less than zero: " + maxReferrers);
        }
        final OopHandle thisHandle = this.saObject.getHandle();
        final ArrayList<ObjectReferenceImpl> objects = new ArrayList<ObjectReferenceImpl>(0);
        final long max = maxReferrers;
        this.vm().saObjectHeap().iterate((HeapVisitor)new DefaultHeapVisitor(){
            private long refCount = 0L;

            public boolean doObj(Oop oop) {
                try {
                    final ObjectReferenceImpl objref = ObjectReferenceImpl.this.vm().objectMirror(oop);
                    objref.visitReferences(new HandleVisitor(){

                        @Override
                        public boolean visit(OopHandle handle) {
                            if (thisHandle.equals(handle)) {
                                objects.add(objref);
                                refCount++;
                                return true;
                            }
                            return false;
                        }
                    });
                    if (max > 0L && this.refCount >= max) {
                        return true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return false;
            }
        });
        return objects;
    }

    private int countLockedObjects(JavaThread jt, Oop obj) {
        int res = 0;
        JavaVFrame frame = jt.getLastJavaVFrameDbg();
        while (frame != null) {
            OopHandle givenHandle = obj.getHandle();
            for (Object monitor2 : JvmUtils.getFrameMonitors(frame)) {
                MonitorInfo mi = (MonitorInfo)monitor2;
                if (mi.eliminated() && frame.isCompiledFrame() || !givenHandle.equals(mi.owner())) continue;
                ++res;
            }
            frame = JvmUtils.getFrameJavaSender(frame);
        }
        return res;
    }

    private List getPendingThreads(ObjectMonitor mon) {
        return this.vm().saVM().getThreads().getPendingThreads(mon);
    }

    private List getWaitingThreads(ObjectMonitor mon) {
        return this.vm().saVM().getThreads().getWaitingThreads(mon);
    }

    private JavaThread owningThreadFromMonitor(Address addr) {
        return this.vm().saVM().getThreads().owningThreadFromMonitor(addr);
    }

    private void computeMonitorInfo() {
        this.monitorInfoCached = true;
        Mark mark = this.saObject.getMark();
        ObjectMonitor mon = null;
        Address owner = null;
        if (!mark.hasMonitor()) {
            if (mark.hasLocker()) {
                owner = mark.locker().getAddress();
            }
        } else {
            mon = mark.monitor();
            owner = mon.owner();
        }
        if (owner != null) {
            this.owningThread = this.vm().threadMirror(this.owningThreadFromMonitor(owner));
        }
        if (this.owningThread != null) {
            if (this.owningThread.getJavaThread().getAddress().equals(owner)) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that((boolean)false, (String)"must have heavyweight monitor with JavaThread * owner");
                }
                this.entryCount = (int)mark.monitor().recursions() + 1;
            } else {
                this.entryCount = this.countLockedObjects(this.owningThread.getJavaThread(), this.saObject);
            }
        }
        this.waitingThreads = new ArrayList<ThreadReferenceImpl>();
        if (mon != null) {
            List pendingThreads = this.getPendingThreads(mon);
            for (Object pendingThread : pendingThreads) {
                this.waitingThreads.add(this.vm().threadMirror((JavaThread)pendingThread));
            }
            List objWaitingThreads = this.getWaitingThreads(mon);
            for (Object objWaitingThread : objWaitingThreads) {
                this.waitingThreads.add(this.vm().threadMirror((JavaThread)objWaitingThread));
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectReferenceImpl) {
            ObjectReferenceImpl other = (ObjectReferenceImpl)obj;
            return this.ref().equals((Object)other.ref()) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.saObject.hashCode();
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 76;
    }

    @Override
    public void writeUntaggedValue(PacketStream packetStream) {
        packetStream.writeObjectRef(this.uniqueID());
    }

    static interface HandleVisitor {
        public boolean visit(OopHandle var1);
    }
}

