/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.AddFullQualifierIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0094\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/UseFullyQualifiedCallFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "referenceExpression", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class UseFullyQualifiedCallFix
extends KotlinQuickFixAction<KtNameReferenceExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName fqName;

    public UseFullyQualifiedCallFix(@NotNull FqName fqName2, @NotNull KtNameReferenceExpression referenceExpression) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
        super((PsiElement)referenceExpression);
        this.fqName = fqName2;
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.use.fully.qualified.call", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)this.getElement();
        if (ktNameReferenceExpression == null) {
            return;
        }
        KtNameReferenceExpression element = ktNameReferenceExpression;
        KtElement result2 = AddFullQualifierIntention.Holder.INSTANCE.applyTo(element, this.fqName);
        ShortenReferences.process$default(ShortenReferences.DEFAULT, result2, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/UseFullyQualifiedCallFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/UseFullyQualifiedCallFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected UseFullyQualifiedCallFix createAction(@NotNull Diagnostic diagnostic) {
            KtElement ktElement;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 warning = (DiagnosticWithParameters1)Errors.COMPATIBILITY_WARNING.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement = warning.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"<get-psiElement>(...)");
            KtElement element = (KtElement)psiElement;
            Object object = warning.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
            CallableDescriptor descriptor2 = (CallableDescriptor)object;
            FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
            if (fqName2 == null) {
                return null;
            }
            FqName fqName3 = fqName2;
            if (element instanceof KtValueArgument) {
                KtCallableReferenceExpression expression;
                KtExpression ktExpression = ((KtValueArgument)element).getArgumentExpression();
                KtCallableReferenceExpression ktCallableReferenceExpression = expression = ktExpression instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)ktExpression : null;
                ktElement = (KtElement)(ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getCallableReference() : null);
            } else {
                ktElement = element;
            }
            KtElement referenceExpression = ktElement;
            KtNameReferenceExpression ktNameReferenceExpression = referenceExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)referenceExpression : null;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression nameReferenceExpression = ktNameReferenceExpression;
            if (!AddFullQualifierIntention.Holder.INSTANCE.isApplicableTo(nameReferenceExpression, (DeclarationDescriptor)descriptor2)) {
                return null;
            }
            return new UseFullyQualifiedCallFix(fqName3, nameReferenceExpression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

