/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.quickfix.ReplaceAndWithWhenGuardFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenEntryGuard;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ReplaceAndWithWhenGuardFixProvider;", "Lcom/intellij/codeInsight/daemon/impl/analysis/ErrorQuickFixProvider;", "<init>", "()V", "createWhenEntryGuard", "Lorg/jetbrains/kotlin/psi/KtWhenEntryGuard;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "text", "", "registerErrorQuickFix", "", "errorElement", "Lcom/intellij/psi/PsiErrorElement;", "builder", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "Companion", "intellij.kotlin.codeInsight.fixes"})
@SourceDebugExtension(value={"SMAP\nReplaceAndWithWhenGuardFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceAndWithWhenGuardFixProvider.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ReplaceAndWithWhenGuardFixProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class ReplaceAndWithWhenGuardFixProvider
implements ErrorQuickFixProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ERROR_DESCRIPTION = "Unexpected '&&', use 'if' to introduce additional conditions; see https://kotl.in/guards-in-when";

    private final KtWhenEntryGuard createWhenEntryGuard(KtPsiFactory $this$createWhenEntryGuard, String text) {
        Object object;
        Object object2 = $this$createWhenEntryGuard;
        try {
            KtPsiFactory $this$createWhenEntryGuard_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$createWhenEntryGuard_u24lambda_u240.createWhenEntry("is Int if " + text + " -> {}").getGuard());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (KtWhenEntryGuard)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    public void registerErrorQuickFix(@NotNull PsiErrorElement errorElement, @NotNull HighlightInfo.Builder builder2) {
        Intrinsics.checkNotNullParameter((Object)errorElement, (String)"errorElement");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        PsiElement psiElement = errorElement.getParent();
        KtWhenEntry ktWhenEntry = psiElement instanceof KtWhenEntry ? (KtWhenEntry)psiElement : null;
        if (ktWhenEntry == null) {
            return;
        }
        KtWhenEntry whenEntry = ktWhenEntry;
        if (whenEntry.isElse()) {
            return;
        }
        if (whenEntry.getConditions().length != 1) {
            return;
        }
        if (!Intrinsics.areEqual((Object)errorElement.getErrorDescription(), (Object)ERROR_DESCRIPTION)) {
            return;
        }
        if (whenEntry.isElse() || whenEntry.getGuard() != null) {
            return;
        }
        Project project = whenEntry.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        String string = errorElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String conditionText = ((Object)StringsKt.trimStart((CharSequence)StringsKt.removePrefix((String)((Object)StringsKt.trimStart((CharSequence)string)).toString(), (CharSequence)"&&"))).toString();
        KtWhenEntryGuard ktWhenEntryGuard = this.createWhenEntryGuard(factory2, conditionText);
        if (ktWhenEntryGuard == null) {
            return;
        }
        KtWhenEntryGuard newGuard = ktWhenEntryGuard;
        KtExpression guardExpression = newGuard.getExpression();
        if (guardExpression instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)guardExpression).getOperationToken(), (Object)KtTokens.OROR)) {
            return;
        }
        builder2.registerFix((ModCommandAction)new ReplaceAndWithWhenGuardFix(errorElement, newGuard), null, null, null, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/ReplaceAndWithWhenGuardFixProvider$Companion;", "", "<init>", "()V", "ERROR_DESCRIPTION", "", "intellij.kotlin.codeInsight.fixes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

