/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.suppress;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinBaseCodeInsightBundle;
import org.jetbrains.kotlin.idea.inspections.suppress.AnnotationHostKind;
import org.jetbrains.kotlin.idea.inspections.suppress.CaretBox;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressIntentionActionKt;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J#\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001e\u0010!\u001a\u00020\u00192\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001e\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\"2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001a\u0010*\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\b\b\u0002\u0010+\u001a\u00020\u0012H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010-\u001a\u00020.H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/suppress/KotlinSuppressIntentionAction;", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "suppressAt", "Lorg/jetbrains/kotlin/psi/KtElement;", "suppressionKey", "", "kind", "Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getText", "isAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isLambdaParameter", "invoke", "", "getFileModifierForPreview", "target", "Lcom/intellij/psi/PsiFile;", "suppressAtFile", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "id", "suppressAtAnnotatedExpression", "Lorg/jetbrains/kotlin/idea/inspections/suppress/CaretBox;", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "suppressAtExpression", "caretBox", "Lorg/jetbrains/kotlin/psi/KtExpression;", "addArgumentToSuppressAnnotation", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "suppressAnnotationText", "withAt", "findSuppressAnnotation", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "annotationList", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "intellij.kotlin.base.codeInsight"})
@SourceDebugExtension(value={"SMAP\nKotlinSuppressIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSuppressIntentionAction.kt\norg/jetbrains/kotlin/idea/inspections/suppress/KotlinSuppressIntentionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class KotlinSuppressIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final String suppressionKey;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final AnnotationHostKind kind;
    @NotNull
    private final SmartPsiElementPointer<KtElement> pointer;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Project project;

    public KotlinSuppressIntentionAction(@NotNull KtElement suppressAt, @NotNull String suppressionKey, @NotNull AnnotationHostKind kind2) {
        Intrinsics.checkNotNullParameter((Object)suppressAt, (String)"suppressAt");
        Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        this.suppressionKey = suppressionKey;
        this.kind = kind2;
        this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)suppressAt));
        Project project = suppressAt.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBaseCodeInsightBundle.message("intention.suppress.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.suppressionKey;
        objectArray[1] = this.kind.getKind();
        String string = this.kind.getName();
        if (string == null) {
            string = "";
        }
        objectArray[2] = string;
        return KotlinBaseCodeInsightBundle.message("intention.suppress.text", objectArray);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isLambdaParameter(element)) {
            return false;
        }
        return element.isValid();
    }

    private final boolean isLambdaParameter(PsiElement element) {
        KtParameter parentParameter;
        if (!Intrinsics.areEqual((Object)this.kind.getKind(), (Object)KotlinBaseCodeInsightBundle.message("declaration.kind.parameter", new Object[0]))) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        Object object = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        if (object == null) {
            PsiElement psiElement2 = element.getParent();
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = psiElement2 instanceof KtDestructuringDeclarationEntry ? (KtDestructuringDeclarationEntry)psiElement2 : null;
            psiElement = ktDestructuringDeclarationEntry != null && (ktDestructuringDeclarationEntry = ktDestructuringDeclarationEntry.getParent()) != null ? ktDestructuringDeclarationEntry.getParent() : null;
            object = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        }
        KtParameter ktParameter = parentParameter = object;
        return ktParameter != null ? ktParameter.isLambdaParameter() : false;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.isValid()) {
            return;
        }
        KtElement ktElement = (KtElement)this.pointer.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement suppressAt = ktElement;
        String suppressionKeyString = "\"" + this.suppressionKey + "\"";
        KtElement ktElement2 = suppressAt;
        if (ktElement2 instanceof KtModifierListOwner) {
            AnnotationModificationUtilsKt.addAnnotation$default((KtModifierListOwner)suppressAt, StandardClassIds.Annotations.INSTANCE.getSuppress(), suppressionKeyString, null, false, this.kind.getNewLineNeeded() ? "\n" : " ", arg_0 -> KotlinSuppressIntentionAction.invoke$lambda$0(this, suppressionKeyString, arg_0), 12, null);
        } else if (ktElement2 instanceof KtAnnotatedExpression) {
            this.suppressAtAnnotatedExpression(new CaretBox<KtExpression>((KtExpression)suppressAt, editor), suppressionKeyString);
        } else if (ktElement2 instanceof KtExpression) {
            this.suppressAtExpression(new CaretBox<KtExpression>((KtExpression)suppressAt, editor), suppressionKeyString);
        } else if (ktElement2 instanceof KtFile) {
            this.suppressAtFile((KtFile)suppressAt, suppressionKeyString);
        }
    }

    @NotNull
    public KotlinSuppressIntentionAction getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PsiElement psiElement = PsiTreeUtil.findSameElementInCopy((PsiElement)this.pointer.getElement(), (PsiFile)target);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findSameElementInCopy(...)");
        return new KotlinSuppressIntentionAction((KtElement)psiElement, this.suppressionKey, this.kind);
    }

    private final void suppressAtFile(KtFile ktFile2, String id) {
        KtPsiFactory psiFactory = new KtPsiFactory(this.project, false, 2, null);
        KtFileAnnotationList fileAnnotationList = ktFile2.getFileAnnotationList();
        if (fileAnnotationList == null) {
            KtFileAnnotationList ktFileAnnotationList;
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(this.suppressAnnotationText(id, false));
            KtPackageDirective packageDirective = ktFile2.getPackageDirective();
            if (packageDirective != null && Intrinsics.areEqual((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)packageDirective)), (Object)ktFile2.getImportList())) {
                PsiElement psiElement = ktFile2.addBefore((PsiElement)newAnnotationList, (PsiElement)packageDirective);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
                ktFileAnnotationList = (KtFileAnnotationList)psiElement;
            } else {
                ktFileAnnotationList = PsiUtilsKt.replaceFileAnnotationList((KtFile)ktFile2, (KtFileAnnotationList)newAnnotationList);
            }
            KtFileAnnotationList createAnnotationList = ktFileAnnotationList;
            ktFile2.addAfter(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind), (PsiElement)createAnnotationList);
            return;
        }
        KtAnnotationEntry suppressAnnotation = this.findSuppressAnnotation(fileAnnotationList);
        if (suppressAnnotation == null) {
            KtAnnotationEntry newSuppressAnnotation = psiFactory.createFileAnnotation(this.suppressAnnotationText(id, false));
            fileAnnotationList.add(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind));
            PsiElement psiElement = fileAnnotationList.add((PsiElement)newSuppressAnnotation);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            KtAnnotationEntry cfr_ignored_0 = (KtAnnotationEntry)psiElement;
            return;
        }
        this.addArgumentToSuppressAnnotation(suppressAnnotation, id);
    }

    private final void suppressAtAnnotatedExpression(CaretBox<? extends KtAnnotatedExpression> suppressAt, String id) {
        KtAnnotationEntry entry = this.findSuppressAnnotation((KtAnnotated)suppressAt.getExpression());
        if (entry != null) {
            this.addArgumentToSuppressAnnotation(entry, id);
        } else {
            this.suppressAtExpression(suppressAt, id);
        }
    }

    private final void suppressAtExpression(CaretBox<? extends KtExpression> caretBox, String id) {
        boolean bl;
        KtExpression suppressAt = caretBox.getExpression();
        boolean bl2 = bl = !(suppressAt instanceof KtDeclaration);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22 = false;
            String $i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22 = "Declarations should have been checked for above";
            throw new AssertionError((Object)$i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22);
        }
        String placeholderText = "PLACEHOLDER_ID";
        KtExpression annotatedExpression = new KtPsiFactory(this.project, false, 2, null).createExpression(KotlinSuppressIntentionAction.suppressAnnotationText$default(this, id, false, 2, null) + "\n" + placeholderText);
        PsiElement psiElement = suppressAt.copy();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement copy = psiElement;
        PsiElement psiElement2 = suppressAt.replace((PsiElement)annotatedExpression);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotatedExpression");
        KtAnnotatedExpression afterReplace = (KtAnnotatedExpression)psiElement2;
        PsiElement psiElement3 = afterReplace.findElementAt(afterReplace.getTextLength() - 2);
        Intrinsics.checkNotNull((Object)psiElement3);
        PsiElement toReplace = psiElement3;
        boolean bl3 = Intrinsics.areEqual((Object)toReplace.getText(), (Object)placeholderText);
        if (_Assertions.ENABLED && !bl3) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiElement psiElement4 = toReplace.replace(copy);
        Intrinsics.checkNotNull((Object)psiElement4);
        PsiElement result2 = psiElement4;
        caretBox.positionCaretInCopy(result2);
    }

    private final void addArgumentToSuppressAnnotation(KtAnnotationEntry entry, String id) {
        KtValueArgumentList args = entry.getValueArgumentList();
        KtPsiFactory psiFactory = new KtPsiFactory(this.project, false, 2, null);
        KtValueArgumentList newArgList = psiFactory.createCallArguments("(" + id + ")");
        PsiElement psiElement = args == null ? entry.addAfter((PsiElement)newArgList, entry.getLastChild()) : (args.getArguments().isEmpty() ? args.replace((PsiElement)newArgList) : (PsiElement)args.addArgument((KtValueArgument)newArgList.getArguments().get(0)));
    }

    private final String suppressAnnotationText(String id, boolean withAt) {
        return (withAt ? "@" : "") + StandardNames.FqNames.suppress.shortName() + "(" + id + ")";
    }

    static /* synthetic */ String suppressAnnotationText$default(KotlinSuppressIntentionAction kotlinSuppressIntentionAction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return kotlinSuppressIntentionAction.suppressAnnotationText(string, bl);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtAnnotated annotated) {
        return AnnotationModificationUtilsKt.findAnnotation$default(annotated, StandardClassIds.Annotations.INSTANCE.getSuppress(), null, false, 6, null);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtFileAnnotationList annotationList) {
        return AnnotationModificationUtilsKt.findAnnotation$default(annotationList, StandardClassIds.Annotations.INSTANCE.getSuppress(), null, false, 6, null);
    }

    private static final boolean invoke$lambda$0(KotlinSuppressIntentionAction this$0, String $suppressionKeyString, KtAnnotationEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this$0.addArgumentToSuppressAnnotation(entry, $suppressionKeyString);
        return true;
    }
}

