/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.idea.gradle.configuration.GradlePropertiesFileFacade;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulatorUtils;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.SettingsScriptBuilder;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleModuleBuilderUtilsKt;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinBuildScriptManipulator;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinGradleFrameworkSupportInModuleConfigurable;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;
import org.jetbrains.kotlin.idea.statistics.WizardStatsService;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleFrameworkSupportProvider;
import org.jetbrains.plugins.gradle.frameworkSupport.KotlinDslGradleFrameworkSupportProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0003H$J\b\u0010!\u001a\u00020\u0003H$J\u0018\u0010\"\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0003H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinDslGradleKotlinFrameworkSupportProvider;", "Lorg/jetbrains/plugins/gradle/frameworkSupport/KotlinDslGradleFrameworkSupportProvider;", "frameworkTypeId", "", "displayName", "frameworkIcon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getFrameworkTypeId", "()Ljava/lang/String;", "getDisplayName", "getFrameworkIcon", "()Ljavax/swing/Icon;", "getFrameworkType", "Lcom/intellij/framework/FrameworkTypeEx;", "createConfigurable", "Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleFrameworkSupportInModuleConfigurable;", "model", "Lcom/intellij/ide/util/frameworkSupport/FrameworkSupportModel;", "addSupport", "", "projectId", "Lcom/intellij/openapi/externalSystem/model/project/ProjectId;", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "modifiableModelsProvider", "Lcom/intellij/openapi/roots/ModifiableModelsProvider;", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "getOldSyntaxPluginDefinition", "getPluginDefinition", "composeDependency", "artifactId", "kotlin.gradle.gradle-java"})
public abstract class KotlinDslGradleKotlinFrameworkSupportProvider
extends KotlinDslGradleFrameworkSupportProvider {
    @NotNull
    private final String frameworkTypeId;
    @NotNull
    private final String displayName;
    @NotNull
    private final Icon frameworkIcon;

    public KotlinDslGradleKotlinFrameworkSupportProvider(@NotNull String frameworkTypeId, @Nls @NotNull String displayName, @NotNull Icon frameworkIcon) {
        Intrinsics.checkNotNullParameter((Object)frameworkTypeId, (String)"frameworkTypeId");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)frameworkIcon, (String)"frameworkIcon");
        this.frameworkTypeId = frameworkTypeId;
        this.displayName = displayName;
        this.frameworkIcon = frameworkIcon;
    }

    @NotNull
    public final String getFrameworkTypeId() {
        return this.frameworkTypeId;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final Icon getFrameworkIcon() {
        return this.frameworkIcon;
    }

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        String string = this.frameworkTypeId;
        return new FrameworkTypeEx(this, string){
            final /* synthetic */ KotlinDslGradleKotlinFrameworkSupportProvider this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public Icon getIcon() {
                return this.this$0.getFrameworkIcon();
            }

            public String getPresentableName() {
                return this.this$0.getDisplayName();
            }

            public FrameworkSupportInModuleProvider createProvider() {
                return (FrameworkSupportInModuleProvider)this.this$0;
            }
        };
    }

    @NotNull
    public KotlinGradleFrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return new KotlinGradleFrameworkSupportInModuleConfigurable(model2, (GradleFrameworkSupportProvider)this);
    }

    public void addSupport(@NotNull ProjectId projectId, @NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        boolean useNewSyntax;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        IdeKotlinVersion kotlinVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        RepositoryDescription additionalRepository = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(kotlinVersion);
        if (KotlinPluginLayout.getStandaloneCompilerVersion().isSnapshot()) {
            kotlinVersion = ConfigureKotlinInProjectUtilsKt.getLAST_SNAPSHOT_VERSION();
        }
        boolean bl = useNewSyntax = buildScriptData.getGradleVersion().compareTo(GradleBuildScriptManipulatorUtils.getMIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX()) >= 0;
        if (useNewSyntax) {
            if (additionalRepository != null) {
                repository = ConfigureKotlinInProjectUtilsKt.toKotlinRepositorySnippet(additionalRepository);
                GradleModuleBuilderUtilsKt.updateSettingsScript(module, (Function1<? super SettingsScriptBuilder<? extends PsiFile>, Unit>)((Function1)arg_0 -> KotlinDslGradleKotlinFrameworkSupportProvider.addSupport$lambda$0(additionalRepository, arg_0)));
                buildScriptData.withMavenCentral();
                buildScriptData.addRepositoriesDefinition(repository);
            }
            v1 = buildScriptData.addPluginDefinitionInPluginsGroup(this.getPluginDefinition() + " version \"" + kotlinVersion.getArtifactVersion() + "\"");
        } else {
            if (additionalRepository != null) {
                repository = ConfigureKotlinInProjectUtilsKt.toKotlinRepositorySnippet(additionalRepository);
                buildScriptData.addBuildscriptRepositoriesDefinition(repository);
                buildScriptData.withMavenCentral();
                buildScriptData.addRepositoriesDefinition(repository);
            }
            v1 = buildScriptData.addPropertyDefinition("val kotlin_version: String by extra").addPluginDefinition(this.getOldSyntaxPluginDefinition()).withBuildScriptMavenCentral().addBuildscriptPropertyDefinition("var kotlin_version: String by extra\n    kotlin_version = \"" + kotlinVersion.getArtifactVersion() + "\"").addBuildscriptDependencyNotation(KotlinBuildScriptManipulator.Companion.getKotlinGradlePluginClassPathSnippet());
        }
        buildScriptData.withMavenCentral();
        boolean isNewProject = Intrinsics.areEqual((Object)module.getProject().getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT), (Object)true);
        if (isNewProject) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ProjectCodeStyleImporter.INSTANCE.apply(project, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            GradlePropertiesFileFacade.Companion.forProject(project2).addCodeStyleProperty("official");
        }
        String string = this.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        WizardStatsService.ProjectCreationStats projectCreationStats = new WizardStatsService.ProjectCreationStats("Gradle", string, "gradleKotlin", null, 8, null);
        WizardStatsService.INSTANCE.logDataOnProjectGenerated(null, module.getProject(), projectCreationStats);
    }

    @NotNull
    protected abstract String getOldSyntaxPluginDefinition();

    @NotNull
    protected abstract String getPluginDefinition();

    @NotNull
    protected final String composeDependency(@NotNull BuildScriptDataBuilder buildScriptData, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return buildScriptData.getGradleVersion().compareTo(GradleBuildScriptManipulatorUtils.getMIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX()) >= 0 ? "implementation(" + KotlinBuildScriptManipulator.Companion.getKotlinModuleDependencySnippet(artifactId, null) + ")" : "implementation(" + KotlinBuildScriptManipulator.Companion.getKotlinModuleDependencySnippet(artifactId, "$kotlin_version") + ")";
    }

    private static final Unit addSupport$lambda$0(RepositoryDescription $additionalRepository, SettingsScriptBuilder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SettingsScriptBuilder $this$addSupport_u24lambda_u240_u240 = it;
        boolean bl = false;
        $this$addSupport_u24lambda_u240_u240.addPluginRepository($additionalRepository);
        $this$addSupport_u24lambda_u240_u240.addMavenCentralPluginRepository();
        $this$addSupport_u24lambda_u240_u240.addPluginRepository(ConfigureKotlinInProjectUtilsKt.getDEFAULT_GRADLE_PLUGIN_REPOSITORY());
        return Unit.INSTANCE;
    }
}

