/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.base.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a'\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0001H\u0086\b\u001aK\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00012\"\u0010\f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000e0\r\"\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000e\u00a2\u0006\u0002\u0010\u000f\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u00a8\u0006\u0011"}, d2={"getRangeOfLine", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/psi/PsiFile;", "line", "", "skipWhitespace", "", "findElementsOfTypeInRange", "", "T", "Lcom/intellij/psi/PsiElement;", "range", "classes", "", "Ljava/lang/Class;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;[Ljava/lang/Class;)Ljava/util/List;", "getParentOfLine", "intellij.kotlin.jvm.debugger.base.util"})
@JvmName(name="JvmDebuggerBasePsiUtils")
@SourceDebugExtension(value={"SMAP\nJvmDebuggerBasePsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDebuggerBasePsiUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/JvmDebuggerBasePsiUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n774#2:58\n865#2,2:59\n*S KotlinDebug\n*F\n+ 1 JvmDebuggerBasePsiUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/JvmDebuggerBasePsiUtils\n*L\n42#1:58\n42#1:59,2\n*E\n"})
public final class JvmDebuggerBasePsiUtils {
    @Nullable
    public static final TextRange getRangeOfLine(@NotNull PsiFile $this$getRangeOfLine, int line, boolean skipWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$getRangeOfLine, (String)"<this>");
        if (line < 0) {
            return null;
        }
        Integer n = PsiLinesUtilsKt.getLineStartOffset($this$getRangeOfLine, line, skipWhitespace);
        if (n == null) {
            return null;
        }
        int startOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset($this$getRangeOfLine, line);
        if (n2 == null) {
            return null;
        }
        int endOffset = n2;
        if (TextRange.isProperRange((int)startOffset, (int)endOffset)) {
            return new TextRange(startOffset, endOffset);
        }
        return null;
    }

    public static /* synthetic */ TextRange getRangeOfLine$default(PsiFile psiFile, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return JvmDebuggerBasePsiUtils.getRangeOfLine(psiFile, n, bl);
    }

    public static final /* synthetic */ <T extends PsiElement> List<T> findElementsOfTypeInRange(PsiFile $this$findElementsOfTypeInRange, TextRange range2) {
        Intrinsics.checkNotNullParameter((Object)$this$findElementsOfTypeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        boolean $i$f$findElementsOfTypeInRange = false;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        return JvmDebuggerBasePsiUtils.findElementsOfTypeInRange($this$findElementsOfTypeInRange, range2, classArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends PsiElement> List<T> findElementsOfTypeInRange(@NotNull PsiFile $this$findElementsOfTypeInRange, @NotNull TextRange range2, Class<? extends T> ... classes) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findElementsOfTypeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        PsiElement psiElement = JvmDebuggerBasePsiUtils.getParentOfLine($this$findElementsOfTypeInRange, range2);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent = psiElement;
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)parent, (boolean)false, (Class[])Arrays.copyOf(classes, classes.length));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement el = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!range2.intersects(el.getTextRange())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PsiElement getParentOfLine(PsiFile $this$getParentOfLine, TextRange range2) {
        PsiElement psiElement = $this$getParentOfLine.findElementAt(range2.getStartOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement parent = psiElement;
        while ((PsiUtilsKt.getStartOffset((PsiElement)parent) > range2.getStartOffset() || PsiUtilsKt.getEndOffset((PsiElement)parent) < range2.getEndOffset()) && parent.getParent() != null) {
        }
        return parent;
    }
}

