/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.coverage;

import com.intellij.coverage.ConditionCoverageExpression;
import com.intellij.coverage.SwitchCoverageExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.coverage.RangePsiVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u001a0\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000f0\u0001*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\fH\u0002\u001a\f\u0010\u0014\u001a\u00020\f*\u00020\nH\u0002\u001a\f\u0010\u0015\u001a\u00020\f*\u00020\nH\u0002\u001a\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"getSwitches", "", "Lcom/intellij/coverage/SwitchCoverageExpression;", "psiFile", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "getConditions", "Lcom/intellij/coverage/ConditionCoverageExpression;", "withoutParentheses", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isBoolOperator", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "breakIntoConditions", "Lkotlin/Pair;", "", "offset", "", "singleElement", "isReversedCondition", "isLeftInOrExpression", "getEnclosingParent", "Lcom/intellij/psi/PsiElement;", "hasDefaultLabel", "switchBlock", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "intellij.kotlin.coverage"})
@SourceDebugExtension(value={"SMAP\nktCoveragePsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ktCoveragePsiUtils.kt\norg/jetbrains/kotlin/idea/coverage/KtCoveragePsiUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,156:1\n1617#2,9:157\n1869#2:166\n1870#2:168\n1626#2:169\n1374#2:172\n1460#2,5:173\n1563#2:178\n1634#2,3:179\n774#2:182\n865#2,2:183\n1761#2,3:190\n1#3:167\n1#3:187\n183#4,2:170\n183#4,2:188\n66#5,2:185\n*S KotlinDebug\n*F\n+ 1 ktCoveragePsiUtils.kt\norg/jetbrains/kotlin/idea/coverage/KtCoveragePsiUtilsKt\n*L\n26#1:157,9\n26#1:166\n26#1:168\n26#1:169\n86#1:172\n86#1:173,5\n87#1:178\n87#1:179,3\n115#1:182\n115#1:183,2\n154#1:190,3\n26#1:167\n38#1:170,2\n150#1:188,2\n137#1:185,2\n*E\n"})
public final class KtCoveragePsiUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SwitchCoverageExpression> getSwitches(@NotNull PsiFile psiFile, @NotNull TextRange range2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        PsiElement psiElement = KtCoveragePsiUtilsKt.getEnclosingParent(psiFile, range2);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent = psiElement;
        List expressions = new ArrayList();
        parent.accept((PsiElementVisitor)new RangePsiVisitor(range2, expressions){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ List<KtWhenExpression> $expressions;
            {
                this.$range = $range;
                this.$expressions = $expressions;
                super($range);
            }

            public void visitWhenExpression(KtWhenExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitWhenExpression(expression);
                if (this.$range.contains(expression.getTextOffset())) {
                    this.$expressions.add(expression);
                }
            }
        });
        Iterable $this$mapNotNull$iv = expressions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SwitchCoverageExpression switchCoverageExpression;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtWhenExpression switchExpression = (KtWhenExpression)element$iv$iv;
            boolean bl2 = false;
            Object object = switchExpression.getSubjectExpression();
            if (object == null || (object = KtCoveragePsiUtilsKt.withoutParentheses(object)) == null || (object = object.getText()) == null) {
                switchCoverageExpression = null;
            } else {
                Object expression = object;
                switchCoverageExpression = new SwitchCoverageExpression((String)expression, null, KtCoveragePsiUtilsKt.hasDefaultLabel(switchExpression));
            }
            if (switchCoverageExpression == null) continue;
            SwitchCoverageExpression it$iv$iv = switchCoverageExpression;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConditionCoverageExpression> getConditions(@NotNull PsiFile psiFile, @NotNull TextRange range2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object v1;
        Object $this$firstOrNull$iv;
        block5: {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            PsiElement psiElement = KtCoveragePsiUtilsKt.getEnclosingParent(psiFile, range2);
            if (psiElement == null) {
                return CollectionsKt.emptyList();
            }
            PsiElement enclosingParent = psiElement;
            $this$firstOrNull$iv = PsiTreeUtilKt.parents((PsiElement)enclosingParent, (boolean)true);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtStatementExpression || it instanceof KtFile)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        PsiElement psiElement = v1;
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent = psiElement;
        LinkedHashSet<KtExpression> expressions = new LinkedHashSet<KtExpression>();
        parent.accept((PsiElementVisitor)new RangePsiVisitor(range2, expressions){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ LinkedHashSet<KtExpression> $expressions;
            {
                this.$range = $range;
                this.$expressions = $expressions;
                super($range);
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (CollectionsKt.contains((Iterable)this.$expressions, (Object)element)) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitIfExpression(KtIfExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Object object = expression.getCondition();
                if (object != null) {
                    KtExpression ktExpression = object;
                    Object object2 = this.$range;
                    PsiElement p0 = (PsiElement)ktExpression;
                    boolean bl = false;
                    object = KtCoveragePsiUtilsKt.access$getConditions$intersectsWithRange(p0, (TextRange)object2) ? ktExpression : null;
                    if (object != null) {
                        ktExpression = object;
                        object2 = this.$expressions;
                        KtExpression it = ktExpression;
                        boolean bl2 = false;
                        ((HashSet)object2).add(it);
                    }
                }
                super.visitIfExpression(expression);
            }

            public void visitForExpression(KtForExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Object object = expression.getLoopRange();
                if (object != null) {
                    KtExpression ktExpression = object;
                    Object object2 = this.$range;
                    PsiElement p0 = (PsiElement)ktExpression;
                    boolean bl = false;
                    object = KtCoveragePsiUtilsKt.access$getConditions$endsInRange(p0, (TextRange)object2) ? ktExpression : null;
                    if (object != null) {
                        ktExpression = object;
                        object2 = this.$expressions;
                        KtExpression it = ktExpression;
                        boolean bl2 = false;
                        ((HashSet)object2).add(it);
                    }
                }
                super.visitForExpression(expression);
            }

            public void visitWhileExpression(KtWhileExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Object object = expression.getCondition();
                if (object != null) {
                    KtExpression ktExpression = object;
                    Object object2 = this.$range;
                    PsiElement p0 = (PsiElement)ktExpression;
                    boolean bl = false;
                    object = KtCoveragePsiUtilsKt.access$getConditions$endsInRange(p0, (TextRange)object2) ? ktExpression : null;
                    if (object != null) {
                        ktExpression = object;
                        object2 = this.$expressions;
                        KtExpression it = ktExpression;
                        boolean bl2 = false;
                        ((HashSet)object2).add(it);
                    }
                }
                super.visitWhileExpression(expression);
            }

            public void visitDoWhileExpression(KtDoWhileExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Object object = expression.getCondition();
                if (object != null) {
                    KtExpression ktExpression = object;
                    Object object2 = this.$range;
                    PsiElement p0 = (PsiElement)ktExpression;
                    boolean bl = false;
                    object = KtCoveragePsiUtilsKt.access$getConditions$endsInRange(p0, (TextRange)object2) ? ktExpression : null;
                    if (object != null) {
                        ktExpression = object;
                        object2 = this.$expressions;
                        KtExpression it = ktExpression;
                        boolean bl2 = false;
                        ((HashSet)object2).add(it);
                    }
                }
                super.visitDoWhileExpression(expression);
            }

            public void visitBinaryExpression(KtBinaryExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (!this.$expressions.contains(expression)) {
                    if (KtCoveragePsiUtilsKt.access$isBoolOperator(expression)) {
                        KtExpression ktExpression = expression.getLeft();
                        if (ktExpression != null) {
                            KtExpression ktExpression2 = ktExpression;
                            LinkedHashSet<KtExpression> linkedHashSet = this.$expressions;
                            KtExpression it = ktExpression2;
                            boolean bl = false;
                            linkedHashSet.add(it);
                        }
                    } else if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.ELVIS)) {
                        this.$expressions.add((KtExpression)expression);
                    }
                }
                super.visitBinaryExpression(expression);
            }

            public void visitSafeQualifiedExpression(KtSafeQualifiedExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.$expressions.add((KtExpression)expression);
                super.visitSafeQualifiedExpression(expression);
            }
        });
        $this$firstOrNull$iv = expressions;
        boolean $i$f$flatMap = false;
        Iterator iterator2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = KtCoveragePsiUtilsKt.breakIntoConditions(it, range2.getStartOffset(), true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KtExpression expression = (KtExpression)pair.component1();
            String text = (String)pair.component2();
            collection.add(new ConditionCoverageExpression(text, KtCoveragePsiUtilsKt.isReversedCondition(expression)));
        }
        return (List)destination$iv$iv;
    }

    private static final KtExpression withoutParentheses(KtExpression $this$withoutParentheses) {
        KtExpression expression = $this$withoutParentheses;
        while (expression instanceof KtParenthesizedExpression) {
            if (((KtParenthesizedExpression)expression).getExpression() != null) continue;
            return null;
        }
        return expression;
    }

    private static final boolean isBoolOperator(KtBinaryExpression $this$isBoolOperator) {
        IElementType iElementType = $this$isBoolOperator.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType token = iElementType;
        return Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR) || Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<KtExpression, String>> breakIntoConditions(KtExpression $this$breakIntoConditions, int offset, boolean singleElement) {
        List list2;
        KtExpression ktExpression = KtCoveragePsiUtilsKt.withoutParentheses($this$breakIntoConditions);
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression expression = ktExpression;
        if (expression instanceof KtBinaryExpression && KtCoveragePsiUtilsKt.isBoolOperator((KtBinaryExpression)expression)) {
            void $this$filterTo$iv$iv;
            Object object;
            Object leftExpressions;
            Object object2 = ((KtBinaryExpression)expression).getLeft();
            if (object2 == null || (object2 = KtCoveragePsiUtilsKt.breakIntoConditions(object2, offset, true)) == null) {
                object2 = leftExpressions = CollectionsKt.emptyList();
            }
            if ((object = ((KtBinaryExpression)expression).getRight()) == null || (object = KtCoveragePsiUtilsKt.breakIntoConditions(object, offset, true)) == null) {
                object = CollectionsKt.emptyList();
            }
            Object rightExpressions = object;
            Iterable $this$filter$iv = CollectionsKt.plus((Collection)((Collection)leftExpressions), (Iterable)((Iterable)rightExpressions));
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(((KtExpression)it.getFirst()).getTextOffset() >= offset)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        if (expression instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression).getOperationToken(), (Object)KtTokens.ELVIS)) {
            KtExpression ktExpression2 = ((KtBinaryExpression)expression).getLeft();
            if (ktExpression2 == null) {
                return CollectionsKt.emptyList();
            }
            KtExpression left = ktExpression2;
            List leftExpressions = KtCoveragePsiUtilsKt.breakIntoConditions$default(left, offset, false, 2, null);
            Object object = ((KtBinaryExpression)expression).getRight();
            if (object == null || (object = KtCoveragePsiUtilsKt.breakIntoConditions$default(object, offset, false, 2, null)) == null) {
                object = CollectionsKt.emptyList();
            }
            Object rightExpressions = object;
            list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)leftExpressions, (Iterable)CollectionsKt.listOf((Object)TuplesKt.to((Object)$this$breakIntoConditions, (Object)(left.getText() + " != null")))), (Iterable)((Iterable)rightExpressions));
        } else if (expression instanceof KtSafeQualifiedExpression) {
            KtExpression left = ((KtSafeQualifiedExpression)expression).getReceiverExpression();
            KtExpression ktExpression3 = ((KtSafeQualifiedExpression)expression).getSelectorExpression();
            if (ktExpression3 == null) {
                return CollectionsKt.emptyList();
            }
            KtExpression right = ktExpression3;
            List leftExpressions = KtCoveragePsiUtilsKt.breakIntoConditions$default(left, offset, false, 2, null);
            List rightExpressions = KtCoveragePsiUtilsKt.breakIntoConditions$default(right, offset, false, 2, null);
            List expressions = right.getTextOffset() >= offset ? CollectionsKt.listOf((Object)TuplesKt.to((Object)$this$breakIntoConditions, (Object)(left.getText() + " != null"))) : CollectionsKt.emptyList();
            list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)leftExpressions, (Iterable)expressions), (Iterable)rightExpressions);
        } else {
            list2 = singleElement ? CollectionsKt.listOf((Object)TuplesKt.to((Object)$this$breakIntoConditions, (Object)expression.getText())) : CollectionsKt.emptyList();
        }
        return list2;
    }

    static /* synthetic */ List breakIntoConditions$default(KtExpression ktExpression, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return KtCoveragePsiUtilsKt.breakIntoConditions(ktExpression, n, bl);
    }

    private static final boolean isReversedCondition(KtExpression $this$isReversedCondition) {
        boolean bl;
        if ($this$isReversedCondition instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)$this$isReversedCondition).getOperationToken(), (Object)KtTokens.ELVIS)) {
            return true;
        }
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$isReversedCondition;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtDoWhileExpression ktDoWhileExpression = (KtDoWhileExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtDoWhileExpression.class, (boolean)true);
        if (ktDoWhileExpression != null && (ktDoWhileExpression = ktDoWhileExpression.getCondition()) != null) {
            KtDoWhileExpression it = ktDoWhileExpression;
            boolean bl2 = false;
            bl = SequencesKt.contains((Sequence)PsiTreeUtilKt.parents((PsiElement)((PsiElement)$this$isReversedCondition), (boolean)true), (Object)it);
        } else {
            bl = false;
        }
        boolean insideDoWhile = bl;
        return insideDoWhile || KtCoveragePsiUtilsKt.isLeftInOrExpression($this$isReversedCondition);
    }

    private static final boolean isLeftInOrExpression(KtExpression $this$isLeftInOrExpression) {
        PsiElement psiElement = $this$isLeftInOrExpression.getParent();
        if (psiElement == null) {
            return false;
        }
        PsiElement parent = psiElement;
        if (!(parent instanceof KtBinaryExpression)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationToken(), (Object)KtTokens.OROR)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getLeft(), (Object)$this$isLeftInOrExpression) || KtCoveragePsiUtilsKt.isLeftInOrExpression((KtExpression)parent);
    }

    private static final PsiElement getEnclosingParent(PsiFile psiFile, TextRange range2) {
        Object v1;
        block2: {
            PsiElement psiElement = psiFile.findElementAt(range2.getStartOffset());
            if (psiElement == null) {
                return null;
            }
            PsiElement elementAt = psiElement;
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.parents((PsiElement)elementAt, (boolean)false);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!it.getTextRange().contains(range2)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private static final boolean hasDefaultLabel(KtWhenExpression switchBlock) {
        boolean bl;
        block3: {
            List list2 = switchBlock.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtWhenEntry p0 = (KtWhenEntry)element$iv;
                    boolean bl2 = false;
                    if (!p0.isElse()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean getConditions$intersectsWithRange(PsiElement $this$getConditions_u24intersectsWithRange, TextRange $range) {
        return $this$getConditions_u24intersectsWithRange.getTextRange().intersects($range);
    }

    private static final boolean getConditions$endsInRange(PsiElement $this$getConditions_u24endsInRange, TextRange $range) {
        return $range.contains($this$getConditions_u24endsInRange.getTextRange().getEndOffset() - 1);
    }

    public static final /* synthetic */ boolean access$isBoolOperator(KtBinaryExpression $receiver) {
        return KtCoveragePsiUtilsKt.isBoolOperator($receiver);
    }

    public static final /* synthetic */ boolean access$getConditions$intersectsWithRange(PsiElement $receiver, TextRange $range) {
        return KtCoveragePsiUtilsKt.getConditions$intersectsWithRange($receiver, $range);
    }

    public static final /* synthetic */ boolean access$getConditions$endsInRange(PsiElement $receiver, TextRange $range) {
        return KtCoveragePsiUtilsKt.getConditions$endsInRange($receiver, $range);
    }
}

