/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.dependencies;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.util.PropertiesCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.script.v1.KotlinScriptSearchScope;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptResidenceExceptionProviderKt;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingLoggerKt;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptConfigurationsProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\f\u001a\u0004\u0018\u00010\u0005*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0011*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0014\u001a\u00020\u0015*\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u001c\u0010\u0017\u001a\u00020\u0011*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0018\u001a\u00020\u0019*\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/dependencies/KotlinScriptResolveScopeProvider;", "Lcom/intellij/psi/ResolveScopeProvider;", "<init>", "()V", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/codeInsight/multiverse/CodeInsightContext;", "getScopeAccordingToLanguageFeature", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getScopeForNonStandaloneScript", "Lorg/jetbrains/kotlin/idea/core/script/v1/KotlinScriptSearchScope;", "getScopeForStandaloneScript", "getScopeForStandaloneScriptUnderSourceRoot", "isStandaloneScriptByDesign", "", "definition", "calculateScopeForStandaloneScript", "debugLog", "", "message", "Lkotlin/Function0;", "", "intellij.kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nKotlinScriptResolveScopeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinScriptResolveScopeProvider.kt\norg/jetbrains/kotlin/idea/core/script/k2/dependencies/KotlinScriptResolveScopeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class KotlinScriptResolveScopeProvider
extends ResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getResolveScope(file, CodeInsightContexts.defaultContext(), project);
    }

    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull CodeInsightContext context2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!FileUtils.isKotlinFileType(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file, context2);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition((PsiFile)ktFile3);
        if (scriptDefinition == null) {
            return null;
        }
        ScriptDefinition scriptDefinition2 = scriptDefinition;
        if (Intrinsics.areEqual(scriptDefinition2.getBaseClassType().getFromClass(), (Object)Reflection.getOrCreateKotlinClass(Object.class))) {
            return null;
        }
        boolean featureEnabled = ScriptResidenceExceptionProviderKt.isEnabled(LanguageFeature.SkipStandaloneScriptsInSourceRoots, GenericPsiUtils.getModule((PsiElement)ktFile3), project);
        boolean backwardCompatibilityIsOn = ScriptResidenceExceptionProviderKt.compilerAllowsAnyScriptsInSourceRoots(project);
        this.debugLog(ktFile3, (Function0<String>)((Function0)() -> KotlinScriptResolveScopeProvider.getResolveScope$lambda$0(featureEnabled, backwardCompatibilityIsOn)));
        if (featureEnabled && !backwardCompatibilityIsOn) {
            return this.getScopeAccordingToLanguageFeature(ktFile3, file, project, scriptDefinition2);
        }
        ScriptingLoggerKt.scriptingDebugLog(ktFile3, (Function0<String>)((Function0)KotlinScriptResolveScopeProvider::getResolveScope$lambda$1));
        return (GlobalSearchScope)this.calculateScopeForStandaloneScript(ktFile3, file, project);
    }

    private final GlobalSearchScope getScopeAccordingToLanguageFeature(KtFile $this$getScopeAccordingToLanguageFeature, VirtualFile file, Project project, ScriptDefinition scriptDefinition) {
        boolean bl = ScriptResidenceExceptionProviderKt.isEnabled(LanguageFeature.SkipStandaloneScriptsInSourceRoots, GenericPsiUtils.getModule((PsiElement)$this$getScopeAccordingToLanguageFeature), project);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "SkipStandaloneScriptsInSourceRoots is off";
            throw new AssertionError((Object)string);
        }
        return this.isStandaloneScriptByDesign($this$getScopeAccordingToLanguageFeature, project, scriptDefinition) ? (GlobalSearchScope)this.getScopeForStandaloneScript($this$getScopeAccordingToLanguageFeature, file, project) : (GlobalSearchScope)this.getScopeForNonStandaloneScript($this$getScopeAccordingToLanguageFeature, file, project);
    }

    private final KotlinScriptSearchScope getScopeForNonStandaloneScript(KtFile $this$getScopeForNonStandaloneScript, VirtualFile file, Project project) {
        KotlinScriptSearchScope kotlinScriptSearchScope;
        boolean underSourceRoot = ProjectStructureUtils.isUnderKotlinSourceRootTypes((PsiElement)$this$getScopeForNonStandaloneScript);
        this.debugLog($this$getScopeForNonStandaloneScript, (Function0<String>)((Function0)() -> KotlinScriptResolveScopeProvider.getScopeForNonStandaloneScript$lambda$0(underSourceRoot)));
        if (underSourceRoot) {
            this.debugLog($this$getScopeForNonStandaloneScript, (Function0<String>)((Function0)KotlinScriptResolveScopeProvider::getScopeForNonStandaloneScript$lambda$1));
            kotlinScriptSearchScope = null;
        } else {
            kotlinScriptSearchScope = this.calculateScopeForStandaloneScript($this$getScopeForNonStandaloneScript, file, project);
        }
        return kotlinScriptSearchScope;
    }

    private final KotlinScriptSearchScope getScopeForStandaloneScript(KtFile $this$getScopeForStandaloneScript, VirtualFile file, Project project) {
        boolean underSourceRoot = ProjectStructureUtils.isUnderKotlinSourceRootTypes((PsiElement)$this$getScopeForStandaloneScript);
        this.debugLog($this$getScopeForStandaloneScript, (Function0<String>)((Function0)() -> KotlinScriptResolveScopeProvider.getScopeForStandaloneScript$lambda$0(underSourceRoot)));
        return underSourceRoot ? this.getScopeForStandaloneScriptUnderSourceRoot($this$getScopeForStandaloneScript, file, project) : this.calculateScopeForStandaloneScript($this$getScopeForStandaloneScript, file, project);
    }

    private final KotlinScriptSearchScope getScopeForStandaloneScriptUnderSourceRoot(KtFile $this$getScopeForStandaloneScriptUnderSourceRoot, VirtualFile file, Project project) {
        KotlinScriptSearchScope kotlinScriptSearchScope;
        boolean hasNoExceptionToBeUnderSourceRoot = ScriptResidenceExceptionProviderKt.hasNoExceptionsToBeUnderSourceRoot(file);
        this.debugLog($this$getScopeForStandaloneScriptUnderSourceRoot, (Function0<String>)((Function0)() -> KotlinScriptResolveScopeProvider.getScopeForStandaloneScriptUnderSourceRoot$lambda$0(hasNoExceptionToBeUnderSourceRoot)));
        if (hasNoExceptionToBeUnderSourceRoot) {
            kotlinScriptSearchScope = this.calculateScopeForStandaloneScript($this$getScopeForStandaloneScriptUnderSourceRoot, file, project);
        } else {
            this.debugLog($this$getScopeForStandaloneScriptUnderSourceRoot, (Function0<String>)((Function0)KotlinScriptResolveScopeProvider::getScopeForStandaloneScriptUnderSourceRoot$lambda$1));
            kotlinScriptSearchScope = null;
        }
        return kotlinScriptSearchScope;
    }

    private final boolean isStandaloneScriptByDesign(KtFile $this$isStandaloneScriptByDesign, Project project, ScriptDefinition definition) {
        Object object = ScriptConfigurationsProvider.Companion.getInstance(project);
        if (object == null || (object = ((ScriptConfigurationsProvider)object).getScriptConfiguration($this$isStandaloneScriptByDesign)) == null || (object = ((ScriptCompilationConfigurationWrapper)object).getConfiguration()) == null) {
            object = definition.getCompilationConfiguration();
        }
        Object configuration2 = object;
        boolean isStandalone = Intrinsics.areEqual((Object)((PropertiesCollection)configuration2).get(ScriptCompilationKt.isStandalone(ScriptCompilationConfiguration.Companion)), (Object)true);
        this.debugLog($this$isStandaloneScriptByDesign, (Function0<String>)((Function0)() -> KotlinScriptResolveScopeProvider.isStandaloneScriptByDesign$lambda$0(isStandalone)));
        return isStandalone;
    }

    private final KotlinScriptSearchScope calculateScopeForStandaloneScript(KtFile $this$calculateScopeForStandaloneScript, VirtualFile file, Project project) {
        VirtualFile virtualFile = $this$calculateScopeForStandaloneScript.getVirtualFile();
        if (virtualFile == null) {
            VirtualFile virtualFile2 = $this$calculateScopeForStandaloneScript.getViewProvider().getVirtualFile();
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        }
        VirtualFile vFile = virtualFile;
        GlobalSearchScope dependenciesScope = ScriptDependencyAware.Companion.getInstance(project).getScriptDependenciesClassFilesScope(vFile);
        this.debugLog($this$calculateScopeForStandaloneScript, (Function0<String>)((Function0)KotlinScriptResolveScopeProvider::calculateScopeForStandaloneScript$lambda$0));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)file).uniteWith(dependenciesScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"uniteWith(...)");
        return new KotlinScriptSearchScope(project, globalSearchScope);
    }

    private final void debugLog(KtFile $this$debugLog, Function0<String> message2) {
        ScriptingLoggerKt.scriptingDebugLog($this$debugLog, (Function0<String>)((Function0)() -> KotlinScriptResolveScopeProvider.debugLog$lambda$0(message2)));
    }

    private static final String getResolveScope$lambda$0(boolean $featureEnabled, boolean $backwardCompatibilityIsOn) {
        return "language-feature: " + $featureEnabled + ", backward-compatibility-flag: " + $backwardCompatibilityIsOn;
    }

    private static final String getResolveScope$lambda$1() {
        return "resolving as standalone";
    }

    private static final String getScopeForNonStandaloneScript$lambda$0(boolean $underSourceRoot) {
        return "under-source-root: " + $underSourceRoot;
    }

    private static final String getScopeForNonStandaloneScript$lambda$1() {
        return "=> in-module";
    }

    private static final String getScopeForStandaloneScript$lambda$0(boolean $underSourceRoot) {
        return "under-source-root: " + $underSourceRoot;
    }

    private static final String getScopeForStandaloneScriptUnderSourceRoot$lambda$0(boolean $hasNoExceptionToBeUnderSourceRoot) {
        return "exception-to-be-under-source-root: " + !$hasNoExceptionToBeUnderSourceRoot;
    }

    private static final String getScopeForStandaloneScriptUnderSourceRoot$lambda$1() {
        return "=> in-module";
    }

    private static final String isStandaloneScriptByDesign$lambda$0(boolean $isStandalone) {
        return "standalone-by-design: " + $isStandalone;
    }

    private static final String calculateScopeForStandaloneScript$lambda$0() {
        return "=> standalone";
    }

    private static final String debugLog$lambda$0(Function0 $message) {
        return "[resolve-scope] " + $message.invoke();
    }
}

