/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.handlers.KeywordConstructLookupObject;
import org.jetbrains.kotlin.idea.completion.handlers.KeywordConstructorInsertionHandler;
import org.jetbrains.kotlin.idea.completion.handlers.LineAdjusterInsertionHandler;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a!\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u0012\u0010\u000f\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u001a\u0010\u0010\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u0012\u001a\u00020\u0001*\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0017\u001a2\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\b\b\u0002\u0010\u001d\u001a\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u0001\u001a\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u001a\u0014\u0010 \u001a\u00020\u0015*\u00020\u00152\u0006\u0010!\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\"\u001a\u00020\u0015*\u00020\u00152\u0006\u0010!\u001a\u00020\u0015H\u0002\u00a8\u0006#"}, d2={"surroundWithBracesIfInStringTemplate", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "removeRedundantBracesInStringTemplate", "", "indexOfSkippingSpace", "", "", "c", "", "startIndex", "(Ljava/lang/CharSequence;CI)Ljava/lang/Integer;", "skipSpaces", "index", "skipSpacesAndLineBreaks", "isCharAt", "offset", "isTextAt", "Lcom/intellij/openapi/editor/Document;", "text", "", "withLineIndentAdjuster", "Lcom/intellij/codeInsight/lookup/LookupElement;", "createKeywordConstructLookupElement", "project", "Lcom/intellij/openapi/project/Project;", "keyword", "fileTextToReformat", "trimSpacesAroundCaret", "adjustLineIndent", "detectIndent", "indentLinesAfterFirst", "indent", "unindent", "kotlin.completion.impl.shared"})
@SourceDebugExtension(value={"SMAP\nhandlerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 handlerUtils.kt\norg/jetbrains/kotlin/idea/completion/handlers/HandlerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,245:1\n295#2,2:246\n295#2,2:248\n648#3,5:250\n*S KotlinDebug\n*F\n+ 1 handlerUtils.kt\norg/jetbrains/kotlin/idea/completion/handlers/HandlerUtilsKt\n*L\n85#1:246,2\n90#1:248,2\n220#1:250,5\n*E\n"})
public final class HandlerUtilsKt {
    public static final boolean surroundWithBracesIfInStringTemplate(@NotNull InsertionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int startOffset = context2.getStartOffset();
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (startOffset > 0 && document2.getCharsSequence().charAt(startOffset - 1) == '$') {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            psiDocumentManager.commitDocument(document2);
            PsiElement psiElement = context2.getFile().findElementAt(startOffset - 1);
            if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
                document2.insertString(startOffset, (CharSequence)"{");
                context2.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + 1);
                int tailOffset = context2.getTailOffset();
                document2.insertString(tailOffset, (CharSequence)"}");
                context2.setTailOffset(tailOffset);
                return true;
            }
        }
        return false;
    }

    public static final void removeRedundantBracesInStringTemplate(@NotNull InsertionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int tailOffset = context2.getTailOffset();
        if (document2.getCharsSequence().charAt(tailOffset) == '}') {
            PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(document2);
            PsiElement token = context2.getFile().findElementAt(tailOffset);
            if (token != null && Intrinsics.areEqual((Object)token.getNode().getElementType(), (Object)KtTokens.LONG_TEMPLATE_ENTRY_END)) {
                PsiElement psiElement = token.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry");
                KtBlockStringTemplateEntry entry = (KtBlockStringTemplateEntry)psiElement;
                KtExpression ktExpression = entry.getExpression();
                KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
                if (ktNameReferenceExpression == null) {
                    return;
                }
                KtNameReferenceExpression nameExpression2 = ktNameReferenceExpression;
                if (KtPsiUtilKt.canPlaceAfterSimpleNameEntry((PsiElement)entry.getNextSibling())) {
                    int n = context2.getTailOffset();
                    context2.setTailOffset(n + 1);
                    String name2 = nameExpression2.getReferencedName();
                    Project project = context2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    KtSimpleNameStringTemplateEntry newEntry = new KtPsiFactory(project, false, 2, null).createSimpleNameStringTemplateEntry(name2);
                    entry.replace((PsiElement)newEntry);
                }
            }
        }
    }

    @Nullable
    public static final Integer indexOfSkippingSpace(@NotNull CharSequence $this$indexOfSkippingSpace, char c, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfSkippingSpace, (String)"<this>");
        int n = $this$indexOfSkippingSpace.length();
        for (int i2 = startIndex; i2 < n; ++i2) {
            char currentChar = $this$indexOfSkippingSpace.charAt(i2);
            if (c == currentChar) {
                return i2;
            }
            if (currentChar == ' ' || currentChar == '\t') continue;
            return null;
        }
        return null;
    }

    public static final int skipSpaces(@NotNull CharSequence $this$skipSpaces, int index2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$skipSpaces, (String)"<this>");
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)index2, (int)$this$skipSpaces.length());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                char c = $this$skipSpaces.charAt(it);
                if (!(c != ' ' && c != '\t')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n.intValue() : $this$skipSpaces.length();
    }

    public static final int skipSpacesAndLineBreaks(@NotNull CharSequence $this$skipSpacesAndLineBreaks, int index2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$skipSpacesAndLineBreaks, (String)"<this>");
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)index2, (int)$this$skipSpacesAndLineBreaks.length());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                char c = $this$skipSpacesAndLineBreaks.charAt(it);
                if (!(c != ' ' && c != '\t' && c != '\n' && c != '\r')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n.intValue() : $this$skipSpacesAndLineBreaks.length();
    }

    public static final boolean isCharAt(@NotNull CharSequence $this$isCharAt, int offset, char c) {
        Intrinsics.checkNotNullParameter((Object)$this$isCharAt, (String)"<this>");
        return offset < $this$isCharAt.length() && $this$isCharAt.charAt(offset) == c;
    }

    public static final boolean isTextAt(@NotNull Document $this$isTextAt, int offset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$isTextAt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return offset + text.length() <= $this$isTextAt.getTextLength() && Intrinsics.areEqual((Object)$this$isTextAt.getText(new TextRange(offset, offset + text.length())), (Object)text);
    }

    @NotNull
    public static final LookupElement withLineIndentAdjuster(@NotNull LookupElement $this$withLineIndentAdjuster) {
        Intrinsics.checkNotNullParameter((Object)$this$withLineIndentAdjuster, (String)"<this>");
        LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withDelegateInsertHandler((LookupElement)$this$withLineIndentAdjuster, (InsertHandler)LineAdjusterInsertionHandler.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementDecorator, (String)"withDelegateInsertHandler(...)");
        return (LookupElement)lookupElementDecorator;
    }

    @NotNull
    public static final LookupElement createKeywordConstructLookupElement(@NotNull Project project, @NotNull String keyword, @NotNull String fileTextToReformat, boolean trimSpacesAroundCaret, boolean adjustLineIndent) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)fileTextToReformat, (String)"fileTextToReformat");
        KtFile file = new KtPsiFactory(project, false, 2, null).createFile(fileTextToReformat);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
        String newFileText = file.getText();
        Intrinsics.checkNotNull((Object)newFileText);
        int keywordOffset = StringsKt.indexOf$default((CharSequence)newFileText, (String)keyword, (int)0, (boolean)false, (int)6, null);
        boolean bl3 = bl2 = keywordOffset >= 0;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int keywordEndOffset = keywordOffset + keyword.length();
        String caretPlaceHolder = "caret";
        int caretOffset = StringsKt.indexOf$default((CharSequence)newFileText, (String)caretPlaceHolder, (int)0, (boolean)false, (int)6, null);
        boolean bl4 = bl = caretOffset >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl5 = bl = caretOffset >= keywordEndOffset;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = newFileText.substring(keywordEndOffset, caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String tailBeforeCaret = string;
        String string2 = newFileText.substring(caretOffset + caretPlaceHolder.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String tailAfterCaret = string2;
        if (trimSpacesAroundCaret) {
            tailBeforeCaret = ((Object)StringsKt.trimEnd((CharSequence)tailBeforeCaret)).toString();
            tailAfterCaret = ((Object)StringsKt.trimStart((CharSequence)tailAfterCaret)).toString();
        }
        String indent = HandlerUtilsKt.detectIndent(newFileText, keywordOffset);
        tailBeforeCaret = HandlerUtilsKt.unindent(tailBeforeCaret, indent);
        tailAfterCaret = HandlerUtilsKt.unindent(tailAfterCaret, indent);
        String tailText = (StringsKt.contains$default((CharSequence)tailBeforeCaret, (char)'\n', (boolean)false, (int)2, null) ? ((Object)StringsKt.trimEnd((CharSequence)StringsKt.replace$default((String)tailBeforeCaret, (String)"\n", (String)"", (boolean)false, (int)4, null))).toString() : tailBeforeCaret) + "..." + (StringsKt.contains$default((CharSequence)tailAfterCaret, (char)'\n', (boolean)false, (int)2, null) ? ((Object)StringsKt.trimStart((CharSequence)StringsKt.replace$default((String)tailAfterCaret, (String)"\n", (String)"", (boolean)false, (int)4, null))).toString() : tailAfterCaret);
        KeywordConstructLookupObject lookupElement2 = new KeywordConstructLookupObject(keyword, fileTextToReformat);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)lookupElement2, (String)keyword).bold().withTailText(tailText).withInsertHandler((InsertHandler)new KeywordConstructorInsertionHandler(keyword, adjustLineIndent, tailBeforeCaret, tailAfterCaret));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        return (LookupElement)lookupElementBuilder;
    }

    public static /* synthetic */ LookupElement createKeywordConstructLookupElement$default(Project project, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return HandlerUtilsKt.createKeywordConstructLookupElement(project, string, string2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String detectIndent(CharSequence text, int offset) {
        String string;
        block1: {
            void var2_2;
            String $this$takeWhile$iv = StringsKt.substringAfterLast$default((String)((Object)text.subSequence(0, offset)).toString(), (char)'\n', null, (int)2, null);
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char p0 = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)p0)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var2_2;
        }
        return string;
    }

    private static final String indentLinesAfterFirst(String $this$indentLinesAfterFirst, String indent) {
        StringBuilder stringBuilder;
        String text = $this$indentLinesAfterFirst;
        StringBuilder $this$indentLinesAfterFirst_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List lines = StringsKt.lines((CharSequence)text);
        Iterator iterator2 = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            String line = (String)iterator2.next();
            if (index2 > 0) {
                $this$indentLinesAfterFirst_u24lambda_u240.append(indent);
            }
            $this$indentLinesAfterFirst_u24lambda_u240.append(line);
            if (index2 == CollectionsKt.getLastIndex((List)lines)) continue;
            $this$indentLinesAfterFirst_u24lambda_u240.append('\n');
        }
        return stringBuilder.toString();
    }

    private static final String unindent(String $this$unindent, String indent) {
        StringBuilder stringBuilder;
        String text = $this$unindent;
        StringBuilder $this$unindent_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List lines = StringsKt.lines((CharSequence)text);
        Iterator iterator2 = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            String line = (String)iterator2.next();
            $this$unindent_u24lambda_u240.append(StringsKt.removePrefix((String)line, (CharSequence)indent));
            if (index2 == CollectionsKt.getLastIndex((List)lines)) continue;
            $this$unindent_u24lambda_u240.append('\n');
        }
        return stringBuilder.toString();
    }

    public static final /* synthetic */ String access$detectIndent(CharSequence text, int offset) {
        return HandlerUtilsKt.detectIndent(text, offset);
    }

    public static final /* synthetic */ String access$indentLinesAfterFirst(String $receiver, String indent) {
        return HandlerUtilsKt.indentLinesAfterFirst($receiver, indent);
    }
}

