/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.InvalidPsiElementTypeException;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.PsiElementSuitabilityChecker;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixFactory;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.UnsupportedPsiElementException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixesPsiBasedFactory;", "PSI", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixFactory;", "classTag", "Lkotlin/reflect/KClass;", "suitabilityChecker", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/PsiElementSuitabilityChecker;", "<init>", "(Lkotlin/reflect/KClass;Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/PsiElementSuitabilityChecker;)V", "createQuickFix", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "psiElement", "checkIfPsiElementIsSupported", "", "doCreateQuickFix", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "intellij.kotlin.codeInsight.api"})
public abstract class QuickFixesPsiBasedFactory<PSI extends PsiElement>
implements QuickFixFactory {
    @NotNull
    private final KClass<PSI> classTag;
    @NotNull
    private final PsiElementSuitabilityChecker<PSI> suitabilityChecker;

    public QuickFixesPsiBasedFactory(@NotNull KClass<PSI> classTag, @NotNull PsiElementSuitabilityChecker<? super PSI> suitabilityChecker) {
        Intrinsics.checkNotNullParameter(classTag, (String)"classTag");
        Intrinsics.checkNotNullParameter(suitabilityChecker, (String)"suitabilityChecker");
        this.classTag = classTag;
        this.suitabilityChecker = suitabilityChecker;
    }

    @NotNull
    public final List<IntentionAction> createQuickFix(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        this.checkIfPsiElementIsSupported(psiElement);
        return this.doCreateQuickFix(psiElement);
    }

    private final void checkIfPsiElementIsSupported(PsiElement psiElement) {
        if (!KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(psiElement.getClass()), this.classTag)) {
            throw new InvalidPsiElementTypeException((KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(psiElement.getClass()), this.classTag, Reflection.getOrCreateKotlinClass(this.getClass()).toString());
        }
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type PSI of org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixesPsiBasedFactory");
        if (!this.suitabilityChecker.isSupported(psiElement)) {
            throw new UnsupportedPsiElementException(psiElement, Reflection.getOrCreateKotlinClass(this.getClass()).toString());
        }
    }

    @NotNull
    protected abstract List<IntentionAction> doCreateQuickFix(@NotNull PSI var1);
}

