/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.types.EnrichedProjectionKind;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ1\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0012\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018JA\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001eJ]\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020 2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\"\u001a\u00020#H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkCallableDeclaration", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "checkTypeParameters", "typeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;Lorg/jetbrains/kotlin/types/Variance;)V", "checkVarianceConflict", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/types/Variance;Lorg/jetbrains/kotlin/KtSourceElement;)V", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "containingType", "isInAbbreviation", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/types/Variance;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/KtSourceElement;Z)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirClassVarianceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirClassVarianceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n812#2,12:194\n1586#2:206\n1661#2,3:207\n*S KotlinDebug\n*F\n+ 1 FirClassVarianceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker\n*L\n34#1:194,12\n34#1:206\n34#1:207,3\n*E\n"})
public final class FirClassVarianceChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirClassVarianceChecker INSTANCE = new FirClassVarianceChecker();

    private FirClassVarianceChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Iterable iterable = declaration.getTypeParameters();
        DiagnosticReporter diagnosticReporter = reporter;
        CheckerContext checkerContext = context2;
        FirClassVarianceChecker firClassVarianceChecker = this;
        boolean $i$f$filterIsInstance = false;
        void var6_10 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirTypeParameter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<FirTypeParameterSymbol> collection = (List)destination$iv$iv;
        $this$filterIsInstance$iv = collection;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        collection = (List)destination$iv$iv;
        firClassVarianceChecker.checkTypeParameters(checkerContext, diagnosticReporter, (List<FirTypeParameterSymbol>)collection, Variance.OUT_VARIANCE);
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, context2, reporter, superTypeRef, Variance.OUT_VARIANCE, null, 16, null);
        }
        DeclarationUtilsKt.processAllDeclarations$default(declaration, context2.getSession(), null, arg_0 -> FirClassVarianceChecker.check$lambda$1(context2, reporter, arg_0), 2, null);
    }

    private final void checkCallableDeclaration(CheckerContext context2, DiagnosticReporter reporter, FirCallableSymbol<?> member) {
        KtSourceElement memberSource = member.getSource();
        if (memberSource != null && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
            for (FirValueParameterSymbol param : member.getContextParameterSymbols()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, context2, reporter, param.getResolvedReturnTypeRef(), Variance.IN_VARIANCE, null, 16, null);
            }
            if (member instanceof FirNamedFunctionSymbol) {
                for (FirValueParameterSymbol param : ((FirNamedFunctionSymbol)member).getValueParameterSymbols()) {
                    FirClassVarianceChecker.checkVarianceConflict$default(this, context2, reporter, param.getResolvedReturnTypeRef(), Variance.IN_VARIANCE, null, 16, null);
                }
            }
        }
        Variance returnTypeVariance = member instanceof FirPropertySymbol && ((FirPropertySymbol)member).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        KtSourceElement returnSource = member.getResolvedReturnTypeRef().getSource();
        if (returnSource != null) {
            if (memberSource != null && returnSource.getKind() instanceof KtFakeSourceElementKind && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
                returnSource = memberSource;
            }
        } else {
            returnSource = memberSource;
        }
        this.checkVarianceConflict(context2, reporter, member.getResolvedReturnTypeRef(), returnTypeVariance, returnSource);
        FirResolvedTypeRef receiverTypeRef = member.getResolvedReceiverTypeRef();
        if (receiverTypeRef != null) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, context2, reporter, receiverTypeRef, Variance.IN_VARIANCE, null, 16, null);
        }
    }

    private final void checkTypeParameters(CheckerContext context2, DiagnosticReporter reporter, List<FirTypeParameterSymbol> typeParameters2, Variance variance) {
        for (FirTypeParameterSymbol typeParameter : typeParameters2) {
            for (FirResolvedTypeRef bound2 : typeParameter.getResolvedBounds()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, context2, reporter, bound2, variance, null, 16, null);
            }
        }
    }

    private final void checkVarianceConflict(CheckerContext context2, DiagnosticReporter reporter, FirTypeRef typeRef, Variance variance, KtSourceElement source) {
        ConeKotlinType expandedType2 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(typeRef));
        KtSourceElement ktSourceElement = source;
        if (ktSourceElement == null) {
            ktSourceElement = typeRef.getSource();
        }
        FirClassVarianceChecker.checkVarianceConflict$default(this, context2, reporter, expandedType2, variance, typeRef, expandedType2, ktSourceElement, false, 128, null);
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, FirTypeRef firTypeRef, Variance variance, KtSourceElement ktSourceElement, int n, Object object) {
        if ((n & 0x10) != 0) {
            ktSourceElement = null;
        }
        firClassVarianceChecker.checkVarianceConflict(checkerContext, diagnosticReporter, firTypeRef, variance, ktSourceElement);
    }

    private final void checkVarianceConflict(CheckerContext context2, DiagnosticReporter reporter, ConeKotlinType type2, Variance variance, FirTypeRef typeRef, ConeKotlinType containingType, KtSourceElement source, boolean isInAbbreviation) {
        ConeClassLikeType fullyExpandedType2;
        FirClassLikeSymbol<?> classSymbol;
        if (type2 instanceof ConeTypeParameterType) {
            KtSourceElement resultSource;
            ConeSimpleKotlinType fullyExpandedType3 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, (ConeSimpleKotlinType)type2);
            FirTypeParameterSymbol typeParameterSymbol = ((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol();
            Object object = source;
            if (object == null) {
                FirTypeRef firTypeRef = typeRef;
                object = firTypeRef != null ? firTypeRef.getSource() : null;
            }
            if ((resultSource = object) != null && !typeParameterSymbol.getVariance().allowsPosition(variance) && !fullyExpandedType3.getAttributes().contains(CompilerConeAttributes.UnsafeVariance.INSTANCE)) {
                KtDiagnosticFactory4<FirTypeParameterSymbol, Variance, Variance, ConeKotlinType> factory2 = isInAbbreviation ? FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_IN_EXPANDED_TYPE() : FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_ERROR();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)resultSource), factory2, (Object)typeParameterSymbol, (Object)typeParameterSymbol.getVariance(), (Object)variance, (Object)containingType, null, (int)128, null);
            }
            return;
        }
        if (type2 instanceof ConeClassLikeType && (classSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, (fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, (ConeClassLikeType)type2)).getLookupTag())) instanceof FirClassSymbol) {
            List<FirTypeRefSource> typeRefAndSourcesForArguments = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
            ConeTypeProjection[] coneTypeProjectionArray = fullyExpandedType2.getTypeArguments();
            int n = coneTypeProjectionArray.length;
            block11: for (int j = 0; j < n; ++j) {
                ConeKotlinType typeArgumentType;
                FirTypeRefSource subTypeRefAndSource;
                Variance variance2;
                Variance variance3;
                int index2 = j;
                ConeTypeProjection typeArgument = coneTypeProjectionArray[j];
                FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.getOrNull(((FirClassSymbol)classSymbol).getTypeParameterSymbols(), (int)index2);
                if (firTypeParameterSymbol == null || (firTypeParameterSymbol = firTypeParameterSymbol.getVariance()) == null) continue;
                FirTypeParameterSymbol paramVariance = firTypeParameterSymbol;
                switch (WhenMappings.$EnumSwitchMapping$0[typeArgument.getKind().ordinal()]) {
                    case 1: {
                        variance3 = Variance.IN_VARIANCE;
                        break;
                    }
                    case 2: {
                        variance3 = Variance.OUT_VARIANCE;
                        break;
                    }
                    case 3: {
                        variance3 = Variance.INVARIANT;
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                Variance argVariance = variance3;
                if (ConeTypeProjectionKt.getType(typeArgument) == null) continue;
                switch (WhenMappings.$EnumSwitchMapping$1[EnrichedProjectionKind.Companion.getEffectiveProjectionKind((Variance)paramVariance, argVariance).ordinal()]) {
                    case 1: {
                        variance2 = variance;
                        break;
                    }
                    case 2: {
                        variance2 = variance.opposite();
                        break;
                    }
                    case 3: {
                        variance2 = Variance.INVARIANT;
                        break;
                    }
                    case 4: {
                        variance2 = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Variance newVariance = variance2;
                if (newVariance == null) continue;
                List<FirTypeRefSource> list2 = typeRefAndSourcesForArguments;
                FirTypeRefSource firTypeRefSource = subTypeRefAndSource = list2 != null ? (FirTypeRefSource)CollectionsKt.getOrNull(list2, (int)index2) : null;
                FirTypeRef firTypeRef = firTypeRefSource != null ? firTypeRefSource.getTypeRef() : null;
                Object object = subTypeRefAndSource;
                if (object == null || (object = ((FirTypeRefSource)object).getTypeRef()) == null || (object = ((FirTypeRef)object).getSource()) == null) {
                    object = source;
                }
                this.checkVarianceConflict(context2, reporter, typeArgumentType, newVariance, firTypeRef, containingType, (KtSourceElement)object, AbbreviatedTypeAttributeKt.isTypealiasExpansion(type2));
            }
        }
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, ConeKotlinType coneKotlinType, Variance variance, FirTypeRef firTypeRef, ConeKotlinType coneKotlinType2, KtSourceElement ktSourceElement, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            ktSourceElement = null;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        firClassVarianceChecker.checkVarianceConflict(checkerContext, diagnosticReporter, coneKotlinType, variance, firTypeRef, coneKotlinType2, ktSourceElement, bl);
    }

    private static final Unit check$lambda$1(CheckerContext $context, DiagnosticReporter $reporter, FirBasedSymbol member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        if (member instanceof FirCallableSymbol) {
            if (Visibilities.INSTANCE.isPrivate(((FirCallableSymbol)member).getResolvedStatus().getVisibility())) {
                return Unit.INSTANCE;
            }
            INSTANCE.checkTypeParameters($context, $reporter, ((FirCallableSymbol)member).getOwnTypeParameterSymbols(), Variance.IN_VARIANCE);
            INSTANCE.checkCallableDeclaration($context, $reporter, (FirCallableSymbol)member);
        }
        if (member instanceof FirClassLikeSymbol) {
            if (Visibilities.INSTANCE.isPrivate(((FirClassLikeSymbol)member).getResolvedStatus().getVisibility())) {
                return Unit.INSTANCE;
            }
            if (!(member instanceof FirClassSymbol)) {
                INSTANCE.checkTypeParameters($context, $reporter, ((FirClassLikeSymbol)member).getOwnTypeParameterSymbols(), Variance.IN_VARIANCE);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EnrichedProjectionKind.values().length];
            try {
                nArray[EnrichedProjectionKind.OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

