/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.ComponentFormatterTemplate;
import org.assertj.swing.format.IntEnum;

public class JOptionPaneFormatter
extends ComponentFormatterTemplate {
    private static final IntEnum MESSAGE_TYPES = new IntEnum();
    private static final IntEnum OPTION_TYPES;

    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        JOptionPane optionPane = (JOptionPane)c;
        String format = "%s[message=%s, messageType=%s, optionType=%s, enabled=%b, visible=%b, showing=%b]";
        return String.format(format, this.getRealClassName(c), Strings.quote((Object)optionPane.getMessage()), MESSAGE_TYPES.get(optionPane.getMessageType()), OPTION_TYPES.get(optionPane.getOptionType()), optionPane.isEnabled(), optionPane.isVisible(), optionPane.isShowing());
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JOptionPane.class;
    }

    static {
        MESSAGE_TYPES.put(0, "ERROR_MESSAGE").put(1, "INFORMATION_MESSAGE").put(2, "WARNING_MESSAGE").put(3, "QUESTION_MESSAGE").put(-1, "PLAIN_MESSAGE");
        OPTION_TYPES = new IntEnum();
        OPTION_TYPES.put(-1, "DEFAULT_OPTION").put(0, "YES_NO_OPTION").put(1, "YES_NO_CANCEL_OPTION").put(3, "QUESTION_MESSAGE").put(2, "OK_CANCEL_OPTION");
    }
}

