/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SpellCheckingInspection
extends LocalInspectionTool
implements DumbAware {
    public static final String SPELL_CHECKING_INSPECTION_TOOL_NAME = "SpellCheckingInspection";

    public static void tokenize(@NotNull PsiElement element, TokenConsumer consumer, Set<SpellCheckingScope> allowedScopes) {
        SpellcheckingStrategy factoryByLanguage;
        if (element == null) {
            SpellCheckingInspection.$$$reportNull$$$0(0);
        }
        if ((factoryByLanguage = SpellcheckingStrategy.getSpellcheckingStrategy(element)) == null) {
            return;
        }
        SpellCheckingInspection.tokenize(factoryByLanguage, element, consumer, allowedScopes);
    }

    public static void tokenize(SpellcheckingStrategy strategy, PsiElement element, TokenConsumer consumer, Set<SpellCheckingScope> allowedScopes) {
        Tokenizer tokenizer = strategy.getTokenizer(element, allowedScopes);
        tokenizer.tokenize(element, consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/inspections/SpellCheckingInspection", "tokenize"));
    }

    public static enum SpellCheckingScope {
        Comments,
        Literals,
        Code;

    }
}

