/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.comment;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequest;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestNewDiscussionPosition;
import org.jetbrains.plugins.gitlab.ui.comment.NewGitLabNoteViewModelBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0094@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0094@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/comment/NewDiffGitLabNoteViewModel;", "Lorg/jetbrains/plugins/gitlab/ui/comment/NewGitLabNoteViewModelBase;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "initialText", "", "mergeRequest", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;", "currentUser", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "position", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestNewDiscussionPosition;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestNewDiscussionPosition;)V", "canSubmitAsDraft", "", "getCanSubmitAsDraft", "()Z", "doSubmit", "", "text", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doSubmitAsDraft", "intellij.vcs.gitlab"})
final class NewDiffGitLabNoteViewModel
extends NewGitLabNoteViewModelBase {
    @NotNull
    private final GitLabMergeRequest mergeRequest;
    @NotNull
    private final GitLabMergeRequestNewDiscussionPosition position;
    private final boolean canSubmitAsDraft;

    public NewDiffGitLabNoteViewModel(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull String initialText, @NotNull GitLabMergeRequest mergeRequest, @NotNull GitLabUserDTO currentUser, @NotNull GitLabMergeRequestNewDiscussionPosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)mergeRequest, (String)"mergeRequest");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        super(project, parentCs, initialText, currentUser);
        this.mergeRequest = mergeRequest;
        this.position = position;
        this.canSubmitAsDraft = this.mergeRequest.getCanAddPositionalDraftNotes();
    }

    @Override
    public boolean getCanSubmitAsDraft() {
        return this.canSubmitAsDraft;
    }

    @Override
    @Nullable
    protected Object doSubmit(@NotNull String text2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.mergeRequest.addNote(this.position, text2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    protected Object doSubmitAsDraft(@NotNull String text2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.mergeRequest.addDraftNote(this.position, text2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

