/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.MediaObject;
import tim.prune.data.TrackInfo;
import tim.prune.data.UnitSet;
import tim.prune.function.edit.FieldEdit;

public class EditPointCmd
extends Command {
    private final int _pointIndex;
    private final List<FieldEdit> _editList;
    private final UnitSet _unitSet;

    public EditPointCmd(int n, List<FieldEdit> list) {
        this(n, list, null);
    }

    public EditPointCmd(int n, FieldEdit fieldEdit) {
        this(n, List.of(fieldEdit), null);
    }

    public EditPointCmd(int n, List<FieldEdit> list, UnitSet unitSet) {
        this(null, n, list, unitSet);
    }

    protected EditPointCmd(EditPointCmd editPointCmd, int n, List<FieldEdit> list, UnitSet unitSet) {
        super(editPointCmd);
        this._pointIndex = n;
        this._editList = list;
        this._unitSet = unitSet;
    }

    @Override
    public int getUpdateFlags() {
        return 2;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        DataPoint dataPoint = trackInfo.getTrack().getPoint(this._pointIndex);
        if (dataPoint == null) {
            return false;
        }
        boolean bl = false;
        for (FieldEdit fieldEdit : this._editList) {
            Field field = fieldEdit.getField();
            dataPoint.setFieldValue(field, fieldEdit.getValue(), this._unitSet, this.isUndo());
            trackInfo.getTrack().getFieldList().addField(field);
            bl |= field.equals(Field.LATITUDE) || field.equals(Field.LONGITUDE) || field.equals(Field.ALTITUDE);
        }
        if (bl && dataPoint.getPhoto() != null) {
            dataPoint.getPhoto().setCurrentStatus(MediaObject.Status.CONNECTED);
        }
        trackInfo.getTrack().requestRescale();
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        DataPoint dataPoint = trackInfo.getTrack().getPoint(this._pointIndex);
        return new EditPointCmd(this, this._pointIndex, this.makeOppositeEdits(dataPoint), this._unitSet);
    }

    private List<FieldEdit> makeOppositeEdits(DataPoint dataPoint) {
        ArrayList<FieldEdit> arrayList = new ArrayList<FieldEdit>();
        for (FieldEdit fieldEdit : this._editList) {
            Field field = fieldEdit.getField();
            arrayList.add(new FieldEdit(field, dataPoint.getFieldValue(field)));
        }
        return arrayList;
    }
}

