/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.cff;

import jogamp.graph.font.typecast.cff.CffFont;
import jogamp.graph.font.typecast.cff.Charstring;

public class CharstringType2
extends Charstring {
    private static final String[] _oneByteOperators = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "-Reserved-", "callsubr", "return", "escape", "-Reserved-", "endchar", "-Reserved-", "-Reserved-", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto"};
    private static final String[] _twoByteOperators = new String[]{"-Reserved- (dotsection)", "-Reserved-", "-Reserved-", "and", "or", "not", "-Reserved-", "-Reserved-", "-Reserved-", "abs", "add", "sub", "div", "-Reserved-", "neg", "eq", "-Reserved-", "-Reserved-", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "-Reserved-", "hflex", "flex", "hflex1", "flex1", "-Reserved-"};
    private final CffFont _font;
    private final int _index;
    private final String _name;
    private final int[] _data;
    private final int _offset;
    private final int _length;

    public CharstringType2(CffFont cffFont, int n, String string, int[] nArray, int n2, int n3) {
        this._font = cffFont;
        this._index = n;
        this._name = string;
        this._data = nArray;
        this._offset = n2;
        this._length = n3;
    }

    public CffFont getFont() {
        return this._font;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public String getName() {
        return this._name;
    }

    private int disassemble(int n, StringBuilder stringBuilder) {
        String string;
        int n2;
        while (this.isOperandAtIndex(n)) {
            Number number = this.operandAtIndex(n);
            stringBuilder.append(number).append(" ");
            n = this.nextOperandIndex(n);
        }
        if ((n2 = this.byteAtIndex(n++)) == 12) {
            if ((n2 = this.byteAtIndex(n++)) > 38) {
                n2 = 38;
            }
            string = _twoByteOperators[n2];
        } else {
            string = _oneByteOperators[n2];
        }
        stringBuilder.append(string);
        return n;
    }

    public int getFirstIndex() {
        return this._offset;
    }

    public boolean isOperandAtIndex(int n) {
        int n2 = this._data[n];
        return 32 <= n2 && n2 <= 255 || n2 == 28;
    }

    public Number operandAtIndex(int n) {
        int n2 = this._data[n];
        if (32 <= n2 && n2 <= 246) {
            return n2 - 139;
        }
        if (247 <= n2 && n2 <= 250) {
            int n3 = this._data[n + 1];
            return (n2 - 247) * 256 + n3 + 108;
        }
        if (251 <= n2 && n2 <= 254) {
            int n4 = this._data[n + 1];
            return -(n2 - 251) * 256 - n4 - 108;
        }
        if (n2 == 28) {
            byte by = (byte)this._data[n + 1];
            int n5 = this._data[n + 2];
            return by << 8 | n5;
        }
        if (n2 == 255) {
            byte by = (byte)this._data[n + 1];
            int n6 = this._data[n + 2];
            int n7 = this._data[n + 3];
            int n8 = this._data[n + 4];
            return Float.valueOf((float)((double)(by << 8 | n6) + (double)(n7 << 8 | n8) / 65536.0));
        }
        return null;
    }

    public int nextOperandIndex(int n) {
        int n2 = this._data[n];
        if (32 <= n2 && n2 <= 246) {
            return n + 1;
        }
        if (247 <= n2 && n2 <= 250) {
            return n + 2;
        }
        if (251 <= n2 && n2 <= 254) {
            return n + 2;
        }
        if (n2 == 28) {
            return n + 3;
        }
        if (n2 == 255) {
            return n + 5;
        }
        return n;
    }

    public int byteAtIndex(int n) {
        return this._data[n];
    }

    public boolean moreBytes(int n) {
        return n < this._offset + this._length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getFirstIndex();
        while (this.moreBytes(n)) {
            n = this.disassemble(n, stringBuilder);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

