/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.erd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDContainer;
import org.jkiss.dbeaver.model.erd.ERDContentProvider;
import org.jkiss.dbeaver.model.erd.ERDContext;
import org.jkiss.dbeaver.model.erd.ERDElement;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDNote;
import org.jkiss.dbeaver.model.erd.ERDObject;
import org.jkiss.dbeaver.model.erd.ERDUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.BaseProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public class ERDDiagram
extends ERDObject<DBSObject>
implements ERDContainer {
    private static final Log log = Log.getLog(ERDDiagram.class);
    private DBRProgressMonitor monitor;
    private final ERDContentProvider contentProvider;
    private String name;
    private final List<ERDEntity> entities = new ArrayList<ERDEntity>();
    private final Map<DBPDataSourceContainer, DataSourceInfo> dataSourceMap = new LinkedHashMap<DBPDataSourceContainer, DataSourceInfo>();
    private final Map<DBPDataSourceContainer, Map<DBSObjectContainer, Integer>> dataSourceContainerMap = new LinkedHashMap<DBPDataSourceContainer, Map<DBSObjectContainer, Integer>>();
    private DBSObjectContainer rootObjectContainer;
    private boolean layoutManualDesired = true;
    private boolean layoutManualAllowed = false;
    private boolean needsAutoLayout;
    private final Map<DBSEntity, ERDEntity> entityMap = new IdentityHashMap<DBSEntity, ERDEntity>();
    private final List<ERDNote> notes = new ArrayList<ERDNote>();
    private final List<String> errorMessages = new ArrayList<String>();

    public DBRProgressMonitor getMonitor() {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            return this.monitor;
        }
        return new BaseProgressMonitor(){

            @NotNull
            public IProgressMonitor getNestedMonitor() {
                return super.getNestedMonitor();
            }
        };
    }

    public void setDiagramMonitor(DBRProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void disableDiagramMonitor() {
        this.monitor = null;
    }

    public ERDDiagram(DBSObject container, String name, ERDContentProvider contentProvider) {
        super(container);
        this.name = name;
        this.contentProvider = contentProvider;
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
    }

    @Override
    public ERDContentProvider getContentProvider() {
        return this.contentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntityOrder(ERDEntity entity) {
        List<ERDEntity> list = this.entities;
        synchronized (list) {
            return this.entities.indexOf(entity);
        }
    }

    public void addEntity(ERDEntity entity, boolean reflect) {
        this.addEntity(entity, -1, reflect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntity(ERDEntity entity, int i, boolean reflect) {
        DBSEntity object = (DBSEntity)entity.getObject();
        if (object == null) {
            log.debug((Object)"Null object passed");
            return;
        }
        if (object.getDataSource() == null) {
            log.debug((Object)("Object " + object.getName() + " is not connected with datasource"));
            return;
        }
        List<ERDEntity> list = this.entities;
        synchronized (list) {
            if (i < 0) {
                this.entities.add(entity);
            } else {
                this.entities.add(i, entity);
            }
            this.entityMap.put(object, entity);
            DBPDataSourceContainer dataSource = object.getDataSource().getContainer();
            DataSourceInfo dsInfo = this.dataSourceMap.computeIfAbsent(dataSource, dsc -> new DataSourceInfo(this.dataSourceMap.size()));
            dsInfo.entities.add(entity);
            DBSObjectContainer container = (DBSObjectContainer)DBUtils.getParentOfType(DBSObjectContainer.class, (DBSObject)((DBSObject)entity.getObject()));
            if (container != null) {
                this.dataSourceContainerMap.putIfAbsent(dataSource, new LinkedHashMap());
                Map<DBSObjectContainer, Integer> containerMap = this.dataSourceContainerMap.get(dataSource);
                containerMap.putIfAbsent(container, containerMap.size());
            }
        }
        if (reflect) {
            this.firePropertyChange("CHILD", null, entity);
        }
        this.resolveRelations(reflect);
        if (reflect) {
            for (ERDAssociation rel : entity.getReferences()) {
                rel.getSourceEntity().firePropertyChange("OUTPUT", null, rel);
            }
            for (ERDAssociation rel : entity.getAssociations()) {
                rel.getTargetEntity().firePropertyChange("INPUT", null, rel);
            }
        }
    }

    private void resolveRelations(boolean reflect) {
        for (ERDEntity erdEntity : this.getEntities()) {
            erdEntity.resolveRelations(this, reflect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeEntity(ERDEntity entity, boolean reflect) {
        List<ERDEntity> list = this.entities;
        synchronized (list) {
            this.entityMap.remove(entity.getObject());
            this.entities.remove(entity);
            DBPDataSourceContainer dataSource = ((DBSEntity)entity.getObject()).getDataSource().getContainer();
            DataSourceInfo dsInfo = this.dataSourceMap.get(dataSource);
            dsInfo.entities.remove(entity);
            if (dsInfo.entities.isEmpty()) {
                this.dataSourceMap.remove(dataSource);
            }
        }
        if (reflect) {
            this.firePropertyChange("CHILD", entity, null);
        }
    }

    @Override
    public List<ERDEntity> getEntities() {
        return this.entities;
    }

    public List<ERDNote> getNotes() {
        return this.notes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNote(ERDNote note, boolean reflect) {
        List<ERDNote> list = this.notes;
        synchronized (list) {
            this.notes.add(note);
        }
        if (reflect) {
            this.firePropertyChange("CHILD", null, note);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(ERDNote note, boolean reflect) {
        List<ERDNote> list = this.notes;
        synchronized (list) {
            this.notes.remove(note);
        }
        if (reflect) {
            this.firePropertyChange("CHILD", note, null);
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLayoutManualAllowed(boolean layoutManualAllowed) {
        this.layoutManualAllowed = layoutManualAllowed;
    }

    public boolean isLayoutManualDesired() {
        return this.layoutManualDesired;
    }

    public void setLayoutManualDesired(boolean layoutManualDesired) {
        this.layoutManualDesired = layoutManualDesired;
    }

    public boolean isEditEnabled() {
        return false;
    }

    public boolean isLayoutManualAllowed() {
        return this.layoutManualAllowed;
    }

    public int getEntityCount() {
        return this.entities.size();
    }

    public ERDDiagram copy() {
        ERDDiagram copy = new ERDDiagram((DBSObject)this.object, this.name, this.contentProvider);
        copy.entities.addAll(this.entities);
        copy.entityMap.putAll(this.entityMap);
        copy.layoutManualDesired = this.layoutManualDesired;
        copy.layoutManualAllowed = this.layoutManualAllowed;
        return copy;
    }

    public void fillEntities(DBRProgressMonitor monitor, Collection<DBSEntity> entities, DBSObject dbObject) throws DBException {
        monitor.beginTask("Load entities metadata", entities.size());
        ArrayList<ERDEntity> entityCache = new ArrayList<ERDEntity>();
        for (DBSEntity table : entities) {
            if (monitor.isCanceled()) break;
            try {
                table = DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)table);
            }
            catch (DBException dBException) {
                log.error((Object)("Error resolving real entity for " + table.getName()));
            }
            if (this.entityMap.containsKey(table)) continue;
            monitor.subTask("Load " + table.getName());
            ERDEntity erdEntity = ERDUtils.makeEntityFromObject(monitor, this, entityCache, table, null);
            erdEntity.setPrimary(table == dbObject);
            this.addEntity(erdEntity, false);
            this.entityMap.put(table, erdEntity);
            entityCache.add(erdEntity);
            monitor.worked(1);
        }
        monitor.done();
        monitor.beginTask("Load entities' relations", entities.size());
        for (ERDEntity erdEntity : entityCache) {
            if (monitor.isCanceled()) break;
            monitor.subTask("Load " + erdEntity.getName());
            try {
                erdEntity.addModelRelations(monitor, this, true, false);
            }
            catch (Exception e) {
                log.warn((Object)"Entity relationship can't be loaded", (Throwable)e);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public boolean containsTable(DBSEntity table) {
        for (ERDEntity erdEntity : this.entities) {
            if (erdEntity.getObject() != table) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<DBSEntity, ERDEntity> getEntityMap() {
        return this.entityMap;
    }

    public ERDEntity getEntity(DBSEntity table) {
        return this.entityMap.get(table);
    }

    public List<ERDEntity> getEntities(DBSEntity table) {
        ArrayList<ERDEntity> result = new ArrayList<ERDEntity>();
        for (ERDEntity entity : this.entities) {
            if (entity.getObject() != table) continue;
            result.add(entity);
        }
        return result;
    }

    @NotNull
    public Collection<DBPDataSourceContainer> getDataSources() {
        return this.dataSourceMap.keySet();
    }

    @Nullable
    public Collection<DBSObjectContainer> getObjectContainers(@NotNull DBPDataSourceContainer dataSourceContainer) {
        Map<DBSObjectContainer, Integer> containers = this.dataSourceContainerMap.get(dataSourceContainer);
        if (containers != null) {
            return containers.keySet();
        }
        return null;
    }

    @Nullable
    public DBSObjectContainer getRootObjectContainer() {
        return this.rootObjectContainer;
    }

    public void setRootObjectContainer(@NotNull DBSObjectContainer rootObjectContainer) {
        this.rootObjectContainer = rootObjectContainer;
    }

    public List<ERDEntity> getEntities(DBPDataSourceContainer dataSourceContainer) {
        DataSourceInfo dsInfo = this.dataSourceMap.get(dataSourceContainer);
        return dsInfo == null ? Collections.emptyList() : dsInfo.entities;
    }

    public int getDataSourceIndex(DBPDataSourceContainer dataSource) {
        DataSourceInfo dsInfo = this.dataSourceMap.get(dataSource);
        return dsInfo == null ? 0 : dsInfo.index;
    }

    public int getContainerIndex(DBPDataSourceContainer dataSource, DBSObjectContainer container) {
        Map<DBSObjectContainer, Integer> containerMap = this.dataSourceContainerMap.get(dataSource);
        if (containerMap != null) {
            Integer index = containerMap.get(container);
            return index == null ? 0 : index;
        }
        return 0;
    }

    public void clear() {
        this.entities.clear();
        this.entityMap.clear();
    }

    public boolean isNeedsAutoLayout() {
        return this.needsAutoLayout;
    }

    public void setNeedsAutoLayout(boolean needsAutoLayout) {
        this.needsAutoLayout = needsAutoLayout;
    }

    public void addInitRelationBends(ERDElement<?> sourceEntity, ERDElement<?> targetEntity, String relName, List<int[]> bends) {
        for (ERDAssociation rel : sourceEntity.getReferences()) {
            if (rel.getSourceEntity() != targetEntity || !relName.equals(((DBSEntityAssociation)rel.getObject()).getName())) continue;
            rel.setInitBends(bends);
        }
    }

    public List<ERDObject<?>> getContents() {
        ArrayList children = new ArrayList(this.entities.size() + this.notes.size());
        children.addAll(this.entities);
        children.addAll(this.notes);
        return children;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public void clearErrorMessages() {
        this.errorMessages.clear();
    }

    @Override
    public void fromMap(@NotNull ERDContext context, Map<String, Object> map) {
        DBPDataSource dataSource = context.getDataSourceContainer().getDataSource();
        if (dataSource == null) {
            log.error((Object)"Can't detect datasource");
            return;
        }
        DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
        if (objectContainer == null) {
            log.error((Object)("Can't detect root object container for " + dataSource.getName()));
            return;
        }
        SQLIdentifierDetector idd = new SQLIdentifierDetector(dataSource.getSQLDialect());
        Map dataList = JSONUtils.getObject(map, (String)"data");
        IntKeyMap idMap = new IntKeyMap();
        try {
            for (Map entityMap : JSONUtils.getObjectList((Map)dataList, (String)"entities")) {
                int entityId = JSONUtils.getInteger((Map)entityMap, (String)"id");
                String entityFQN = JSONUtils.getString((Map)entityMap, (String)"fqn");
                if (CommonUtils.isEmpty((String)entityFQN)) {
                    entityFQN = JSONUtils.getString((Map)entityMap, (String)"name");
                }
                String[] idParts = idd.splitIdentifier(entityFQN);
                String tableName = idParts[idParts.length - 1];
                String schemaName = idParts.length > 2 ? idParts[1] : (idParts.length > 1 ? idParts[0] : null);
                String catalogName = idParts.length > 2 ? idParts[0] : null;
                DBSObject entity = DBUtils.getObjectByPath((DBRProgressMonitor)context.getMonitor(), (DBCExecutionContext)DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true), (DBSObjectContainer)objectContainer, (String)catalogName, (String)schemaName, (String)tableName);
                if (!(entity instanceof DBSEntity)) {
                    log.error((Object)("Can't find entity " + entityFQN + " in " + objectContainer.getName()));
                    continue;
                }
                ERDEntity erdEntity = new ERDEntity((DBSEntity)entity);
                erdEntity.fromMap(context, entityMap);
                idMap.put(entityId, (Object)erdEntity);
                this.addEntity(erdEntity, false);
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
    }

    @Override
    public Map<String, Object> toMap(@NotNull ERDContext context, boolean fullInfo) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("entities", this.getEntities().stream().map(e -> e.toMap(context, fullInfo)).collect(Collectors.toList()));
        ArrayList<ERDElement> allElements = new ArrayList<ERDElement>();
        allElements.addAll(this.getEntities());
        allElements.addAll(this.getNotes());
        ArrayList<Map<String, Object>> assocList = new ArrayList<Map<String, Object>>();
        for (ERDElement element : allElements) {
            for (ERDAssociation rel : element.getAssociations()) {
                assocList.add(rel.toMap(context, fullInfo));
            }
        }
        map.put("associations", assocList);
        if (fullInfo) {
            LinkedHashMap<String, List<String>> dataList = new LinkedHashMap<String, List<String>>();
            map.put("data", dataList);
            dataList.put("icons", context.getIcons());
        }
        return map;
    }

    private static class DataSourceInfo {
        int index;
        List<ERDEntity> entities = new ArrayList<ERDEntity>();

        public DataSourceInfo(int index) {
            this.index = index;
        }
    }
}

