/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContext;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.utils.CommonUtils;

public class ResultSetPanelDescriptor
extends AbstractContextDescriptor {
    private static final Log log = Log.getLog(ResultSetPanelDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resultset.panel";
    public static final String TAG_SUPPORTS = "supports";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final boolean showByDefault;
    private final List<IResultSetPresentation.PresentationType> supportedPresentationTypes = new ArrayList<IResultSetPresentation.PresentationType>();
    private final List<String> supportedPresentations = new ArrayList<String>();
    private final List<String> supportedDataSources = new ArrayList<String>();
    private final List<JexlExpression> supportedExpressions = new ArrayList<JexlExpression>();

    public ResultSetPanelDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.showByDefault = CommonUtils.toBoolean((Object)config.getAttribute("default"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren(TAG_SUPPORTS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String expr;
            String id;
            IConfigurationElement supports = iConfigurationElementArray[n2];
            String type = supports.getAttribute("type");
            if (!CommonUtils.isEmpty((String)type)) {
                this.supportedPresentationTypes.add(IResultSetPresentation.PresentationType.valueOf(type.toUpperCase(Locale.ENGLISH)));
            }
            if (!CommonUtils.isEmpty((String)(id = supports.getAttribute("id")))) {
                this.supportedPresentations.add(id);
            }
            if (!CommonUtils.isEmpty((String)(expr = supports.getAttribute("if")))) {
                try {
                    this.supportedExpressions.add(ResultSetPanelDescriptor.parseExpression((String)expr));
                }
                catch (DBException e) {
                    log.debug((Object)e);
                }
            }
            ++n2;
        }
        iConfigurationElementArray = config.getChildren("datasource");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsElement = iConfigurationElementArray[n2];
            String dsId = dsElement.getAttribute("id");
            if (dsId != null) {
                this.supportedDataSources.add(dsId);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isShowByDefault() {
        return this.showByDefault;
    }

    public boolean supportedBy(IResultSetContext context, DBPDataSource dataSource, String presentationId, IResultSetPresentation.PresentationType presentationType) {
        if (!this.supportedDataSources.isEmpty()) {
            if (dataSource == null) {
                return false;
            }
            if (!this.supportsAnyProvider(dataSource)) {
                return false;
            }
        }
        if (!this.supportedExpressions.isEmpty()) {
            for (JexlExpression expr : this.supportedExpressions) {
                if (Boolean.TRUE.equals(expr.evaluate(AbstractDescriptor.makeContext((Object)dataSource, (Object)context)))) continue;
                return false;
            }
        }
        if (this.supportedPresentations.isEmpty() && this.supportedPresentationTypes.isEmpty()) {
            return true;
        }
        return presentationId != null && this.supportedPresentations.contains(presentationId) || presentationType != null && this.supportedPresentationTypes.contains((Object)presentationType);
    }

    private boolean supportsAnyProvider(DBPDataSource dataSource) {
        DBPDataSourceProviderDescriptor provider = dataSource.getContainer().getDriver().getProviderDescriptor();
        while (provider != null) {
            if (this.supportedDataSources.contains(provider.getId())) {
                return true;
            }
            provider = provider.getParentProvider();
        }
        return false;
    }

    public IResultSetPanel createInstance() throws DBException {
        return (IResultSetPanel)this.implClass.createInstance(IResultSetPanel.class);
    }

    public String toString() {
        return this.id;
    }
}

