/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.Log;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

class ApplicationCSSManager {
    private static final Log log = Log.getLog(ApplicationCSSManager.class);
    private static final String TABBED_FOLDER_STYLE = "TabbedFolderList { background-color: inherit; }";

    ApplicationCSSManager() {
    }

    static void updateApplicationCSS(Display display) {
        CSSEngine engine = WidgetElement.getEngine((Display)display);
        if (engine == null) {
            log.error((Object)"No CSSEngine");
            return;
        }
        ExtendedDocumentCSS doc = (ExtendedDocumentCSS)engine.getDocumentCSS();
        ArrayList<StyleSheet> sheets = new ArrayList<StyleSheet>();
        StyleSheetList list = doc.getStyleSheets();
        int i = 0;
        while (i < list.getLength()) {
            sheets.add(list.item(i));
            ++i;
        }
        try {
            StringReader reader = new StringReader(TABBED_FOLDER_STYLE);
            sheets.add(engine.parseStyleSheet((Reader)reader));
            doc.removeAllStyleSheets();
            for (StyleSheet sheet : sheets) {
                doc.addStyleSheet(sheet);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

