/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeIcon;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class DBXTreeNode {
    private static final Log log = Log.getLog(DBXTreeNode.class);
    private final AbstractDescriptor source;
    private final DBXTreeNode parent;
    private final IConfigurationElement config;
    private final String id;
    private List<DBXTreeNode> children;
    private DBPImage defaultIcon;
    private List<DBXTreeIcon> icons;
    private final boolean navigable;
    private final boolean inline;
    private final boolean virtual;
    private final boolean standaloneNode;
    private JexlExpression visibleIf;
    private DBXTreeNode recursiveLink;
    private List<DBXTreeNodeHandler> handlers = null;

    public DBXTreeNode(@NotNull AbstractDescriptor source, @Nullable DBXTreeNode parent, @Nullable IConfigurationElement config, boolean navigable, boolean inline, boolean virtual, boolean standalone, @Nullable String visibleIf, @Nullable String recursive) {
        this.source = source;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.config = config;
        this.id = config == null ? null : config.getAttribute("id");
        this.navigable = navigable;
        this.inline = inline;
        this.virtual = virtual;
        this.standaloneNode = standalone;
        if (!CommonUtils.isEmpty((String)visibleIf)) {
            try {
                this.visibleIf = AbstractDescriptor.parseExpression(visibleIf);
            }
            catch (DBException e) {
                log.debug("Error parsing expression '" + visibleIf + "':" + GeneralUtils.getExpressionParseMessage(e));
            }
        }
        if (recursive != null) {
            this.recursiveLink = this;
            String[] stringArray = recursive.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.equals("..")) {
                    this.recursiveLink = this.recursiveLink.parent;
                }
                ++n2;
            }
        }
    }

    public DBXTreeNode(@NotNull AbstractDescriptor source, @Nullable DBXTreeNode parent, @NotNull DBXTreeNode node) {
        this.source = source;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.config = node.config;
        this.id = node.id;
        this.navigable = node.navigable;
        this.inline = node.inline;
        this.virtual = node.virtual;
        this.standaloneNode = node.standaloneNode;
        this.visibleIf = node.visibleIf;
        this.defaultIcon = node.defaultIcon;
        if (node.icons != null) {
            this.icons = new ArrayList<DBXTreeIcon>(node.icons);
        }
        if (node.children != null) {
            this.children = new ArrayList<DBXTreeNode>(node.children.size());
            for (DBXTreeNode child : node.children) {
                if (child instanceof DBXTreeObject) {
                    new DBXTreeObject(source, this, (DBXTreeObject)child);
                    continue;
                }
                if (child instanceof DBXTreeFolder) {
                    new DBXTreeFolder(source, this, (DBXTreeFolder)child);
                    continue;
                }
                new DBXTreeItem(source, this, (DBXTreeItem)child);
            }
        }
        if (node.handlers != null) {
            this.handlers = new ArrayList<DBXTreeNodeHandler>(node.handlers);
        }
    }

    @Nullable
    protected IConfigurationElement getConfig() {
        return this.config;
    }

    @NotNull
    public AbstractDescriptor getSource() {
        return this.source;
    }

    public abstract String getNodeTypeLabel(@Nullable DBPDataSource var1, @Nullable String var2);

    public abstract String getChildrenTypeLabel(@Nullable DBPDataSource var1, @Nullable String var2);

    public boolean isNavigable() {
        return this.navigable;
    }

    public boolean isInline() {
        return this.inline;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isStandaloneNode() {
        return this.standaloneNode;
    }

    public DBXTreeNode getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasChildren(DBNNode context) {
        return this.hasChildren(context, false);
    }

    public boolean hasChildren(DBNNode context, boolean navigable) {
        if (context instanceof DBNDataSource) {
            return true;
        }
        if (CommonUtils.isEmpty(this.children)) {
            return this.recursiveLink != null && this.recursiveLink.hasChildren(context, navigable);
        }
        if (context == null) {
            return true;
        }
        for (DBXTreeNode child : this.children) {
            if (navigable && !child.isNavigable() || !child.isVisible(context)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected List<DBXTreeNode> getChildren() {
        return this.children;
    }

    @NotNull
    public List<DBXTreeNode> getChildren(@Nullable DBNNode context) {
        if (context != null && !CommonUtils.isEmpty(this.children)) {
            boolean hasExpr = false;
            for (DBXTreeNode child : this.children) {
                if (child.getVisibleIf() == null) continue;
                hasExpr = true;
                break;
            }
            if (hasExpr) {
                ArrayList<DBXTreeNode> filteredChildren = new ArrayList<DBXTreeNode>(this.children.size());
                for (DBXTreeNode child : this.children) {
                    if (!child.isVisible(context)) continue;
                    filteredChildren.add(child);
                }
                return filteredChildren;
            }
        }
        if (this.children == null) {
            if (this.recursiveLink != null) {
                return this.recursiveLink.getChildren(context);
            }
            return Collections.emptyList();
        }
        return this.children;
    }

    public void clearChildren() {
        this.children.clear();
    }

    protected boolean isVisible(@Nullable DBNNode context) {
        DBNDatabaseNode dbNode;
        if (context instanceof DBNDatabaseNode && (dbNode = (DBNDatabaseNode)context).getObject() == null) {
            return false;
        }
        try {
            return this.visibleIf == null || Boolean.TRUE.equals(this.visibleIf.evaluate(DBNUtils.makeContext(context)));
        }
        catch (JexlException e) {
            log.debug("Error evaluating tree node expression '" + this.visibleIf.getSourceText() + "' on node '" + context.getName() + "': " + GeneralUtils.getExpressionParseMessage((Exception)((Object)e)));
            return false;
        }
    }

    public void addChild(@NotNull DBXTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<DBXTreeNode>();
        }
        this.children.add(child);
    }

    @Nullable
    public DBXTreeNode getRecursiveLink() {
        return this.recursiveLink;
    }

    @Nullable
    public DBPImage getDefaultIcon() {
        if (this.defaultIcon == null && this instanceof DBXTreeFolder) {
            return DBIcon.TREE_FOLDER;
        }
        return this.defaultIcon;
    }

    public void setDefaultIcon(@Nullable DBPImage defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @NotNull
    public List<DBXTreeIcon> getIcons() {
        return this.icons;
    }

    public void addIcon(@NotNull DBXTreeIcon icon) {
        if (this.icons == null) {
            this.icons = new ArrayList<DBXTreeIcon>();
        }
        this.icons.add(icon);
    }

    @Nullable
    public DBPImage getIcon(@Nullable DBNNode context) {
        List<DBXTreeIcon> extIcons = this.getIcons();
        if (!CommonUtils.isEmpty(extIcons) && context != null) {
            for (DBXTreeIcon icon : extIcons) {
                JexlExpression iconExpression = icon.getExpression();
                if (iconExpression == null) continue;
                try {
                    Object result = iconExpression.evaluate(DBNUtils.makeContext(context));
                    if (!Boolean.TRUE.equals(result)) continue;
                    return icon.getIcon();
                }
                catch (JexlException e) {
                    log.trace("Error evaluating node icon expression '" + icon.getExprString() + "' on node '" + context.getName() + "': " + GeneralUtils.getExpressionParseMessage((Exception)((Object)e)));
                }
            }
        }
        return this.getDefaultIcon();
    }

    @Nullable
    public JexlExpression getVisibleIf() {
        return this.visibleIf;
    }

    public String toString() {
        return "Node " + this.id;
    }

    public void addActionHandler(@NotNull DBXTreeNodeHandler.Action action, @NotNull DBXTreeNodeHandler.Perform perform, @NotNull String command) {
        if (this.handlers == null) {
            this.handlers = new ArrayList<DBXTreeNodeHandler>();
        }
        this.handlers.add(new DBXTreeNodeHandler(action, perform, command));
    }

    @Nullable
    public DBXTreeNodeHandler getHandler(@NotNull DBXTreeNodeHandler.Action action) {
        if (this.handlers != null) {
            for (DBXTreeNodeHandler handler : this.handlers) {
                if (handler.getAction() != action) continue;
                return handler;
            }
        }
        return null;
    }

    public void moveChildAfter(@NotNull DBXTreeNode child, @NotNull DBXTreeNode afterItem) {
        int afterIndex = -1;
        int i = 0;
        while (i < this.children.size()) {
            DBXTreeNode n = this.children.get(i);
            if (n == afterItem || n instanceof DBXTreeFolder && n.getChildren() != null && n.getChildren().size() == 1 && n.getChildren().getFirst() == afterItem) {
                afterIndex = i;
                break;
            }
            ++i;
        }
        if (afterIndex >= 0) {
            this.children.remove(child);
            this.children.add(afterIndex + 1, child);
        }
    }

    public void removeChild(DBXTreeItem item) {
        if (this.children != null) {
            this.children.remove(item);
        }
    }

    public static boolean hasNonFolderNode(@NotNull List<DBXTreeNode> list) {
        return list.stream().anyMatch(dbxTreeNode -> !(dbxTreeNode instanceof DBXTreeFolder));
    }
}

