/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.app.DBPProjectManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeExtendable;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.registry.DBNRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBNRoot
extends DBNNode
implements DBNContainer,
DBNNodeExtendable,
DBPProjectListener {
    private final DBNModel model;
    private final List<DBNProject> projects = new ArrayList<DBNProject>();
    private final List<DBNNode> extraNodes = new ArrayList<DBNNode>();

    public DBNRoot(@NotNull DBNModel model) {
        Object object;
        this.model = model;
        List<? extends DBPProject> globalProjects = model.getModelProjects();
        if (globalProjects != null) {
            object = globalProjects.iterator();
            while (object.hasNext()) {
                project = object.next();
                this.addProject(project, false);
            }
        } else {
            object = DBWorkbench.getPlatform().getWorkspace().getProjects().iterator();
            while (object.hasNext()) {
                project = object.next();
                this.addProject(project, false);
            }
        }
        if (model.isGlobal() && (object = DBWorkbench.getPlatform().getWorkspace()) instanceof DBPProjectManager) {
            DBPProjectManager projectManager = (DBPProjectManager)object;
            projectManager.addProjectListener(this);
        }
        DBNRegistry.getInstance().extendNode(this, false);
    }

    @Override
    protected void dispose(boolean reflect) {
        for (DBNProject project : this.projects) {
            DBNUtils.disposeNode(project, reflect);
        }
        this.projects.clear();
        Object object = this.extraNodes.iterator();
        while (object.hasNext()) {
            DBNNode node = object.next();
            DBNUtils.disposeNode(node, reflect);
        }
        this.extraNodes.clear();
        if (this.model.isGlobal() && (object = DBWorkbench.getPlatform().getWorkspace()) instanceof DBPProjectManager) {
            DBPProjectManager projectManager = (DBPProjectManager)object;
            projectManager.removeProjectListener(this);
        }
    }

    @Override
    public DBNModel getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public String getNodeType() {
        return ModelMessages.model_navigator_Root;
    }

    @Override
    @Nullable
    public Object getValueObject() {
        return this;
    }

    @Override
    @NotNull
    public String getChildrenType() {
        return ModelMessages.model_navigator_Project;
    }

    @Override
    @Nullable
    public Class<?> getChildrenClass() {
        return Object.class;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @NotNull
    public String getNodeDisplayName() {
        return "#root";
    }

    @Override
    @Nullable
    public String getNodeDescription() {
        return ModelMessages.model_navigator_Model_root;
    }

    @Override
    @Nullable
    public DBPImage getNodeIcon() {
        return null;
    }

    @Override
    public boolean allowsChildren() {
        return !this.projects.isEmpty() || !this.extraNodes.isEmpty();
    }

    @Override
    @Nullable
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) {
        if (this.extraNodes.isEmpty()) {
            return this.projects.toArray(new DBNNode[0]);
        }
        if (this.projects.isEmpty()) {
            return this.extraNodes.toArray(new DBNNode[0]);
        }
        ArrayList<DBNNode> children = new ArrayList<DBNNode>(this.projects.size() + this.extraNodes.size());
        children.addAll(this.projects);
        children.addAll(this.extraNodes);
        return children.toArray(new DBNNode[0]);
    }

    @NotNull
    public List<DBNProject> getProjects() {
        return this.projects;
    }

    @Override
    @NotNull
    public List<DBNNode> getExtraNodes() {
        return this.extraNodes;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        if (this.getParentNode() != null) {
            return this.getParentNode().refreshNode(monitor, source);
        }
        for (DBNProject project : this.projects) {
            project.refreshNode(monitor, source);
        }
        return this;
    }

    @Override
    @Deprecated
    @NotNull
    public String getNodeItemPath() {
        return "";
    }

    @Nullable
    public DBNProject getProjectNode(@Nullable DBPProject project) {
        if (project == null) {
            return null;
        }
        for (DBNProject node : this.projects) {
            if (!node.getProject().equals(project) && !CommonUtils.equalObjects((Object)node.getProject().getId(), (Object)project.getId())) continue;
            return node;
        }
        return null;
    }

    public DBNProject addProject(@NotNull DBPProject project, boolean reflect) {
        DBNProject projectNode = this.getModel().createProjectNode(this, project);
        this.projects.add(projectNode);
        this.projects.sort((o1, o2) -> o1.getNodeDisplayName().compareToIgnoreCase(o2.getNodeDisplayName()));
        if (reflect) {
            this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, projectNode));
        }
        return projectNode;
    }

    public void removeProject(@NotNull DBPProject project) {
        int i = 0;
        while (i < this.projects.size()) {
            DBNProject projectNode = this.projects.get(i);
            if (projectNode.getProject() == project) {
                this.projects.remove(i);
                this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, projectNode));
                DBNUtils.disposeNode(projectNode, true);
                break;
            }
            ++i;
        }
    }

    @Override
    public void addExtraNode(@NotNull DBNNode node, boolean reflect) {
        this.extraNodes.add(node);
        this.extraNodes.sort(Comparator.comparing(DBNNode::getNodeDisplayName));
        this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, node));
    }

    @Override
    public void removeExtraNode(@NotNull DBNNode node) {
        if (this.extraNodes.remove(node)) {
            this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, node));
        }
    }

    @Override
    public void handleProjectAdd(@NotNull DBPProject project) {
        this.addProject(project, true);
    }

    @Override
    public void handleProjectRemove(@NotNull DBPProject project) {
        this.removeProject(project);
    }

    @Override
    public void handleActiveProjectChange(@NotNull DBPProject oldValue, @NotNull DBPProject newValue) {
        DBNProject projectNode = this.getProjectNode(newValue);
        DBNProject oldProjectNode = this.getProjectNode(oldValue);
        if (projectNode != null) {
            this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.UPDATE, projectNode));
        }
        if (oldProjectNode != null) {
            this.model.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.UPDATE, oldProjectNode));
        }
    }
}

