/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorDDL
extends SQLGenerator<DBPScriptObject> {
    @Override
    public boolean isDDLOption() {
        return true;
    }

    @Override
    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        boolean allTables = true;
        ArrayList<DBSTable> tableList = new ArrayList<DBSTable>();
        for (DBPScriptObject object : this.objects) {
            if (!(object instanceof DBSTable)) {
                allTables = false;
                break;
            }
            tableList.add((DBSTable)object);
        }
        if (!allTables) {
            super.run(monitor);
            return;
        }
        StringBuilder sql = new StringBuilder(100);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.addOptions(options);
        try {
            DBStructUtils.generateTableListDDL((DBRProgressMonitor)monitor, (StringBuilder)sql, tableList, options, (boolean)false);
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
        this.result = sql.toString().trim();
    }

    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBPScriptObject object) throws DBException {
        String extendedDefinitionText;
        if (sql.length() > 0) {
            sql.append("\n");
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("refresh", true);
        this.addOptions(options);
        String definitionText = CommonUtils.notEmpty((String)object.getObjectDefinitionText(monitor, options)).trim();
        sql.append(definitionText);
        String delimiter = ";";
        if (object instanceof DBSObject) {
            SQLDialect sqlDialect = ((DBSObject)object).getDataSource().getSQLDialect();
            delimiter = SQLUtils.getDefaultScriptDelimiter((SQLDialect)sqlDialect);
        }
        if (!definitionText.endsWith(delimiter)) {
            sql.append(";");
        }
        sql.append("\n");
        if (object instanceof DBPScriptObjectExt && CommonUtils.isNotEmpty((String)(extendedDefinitionText = ((DBPScriptObjectExt)object).getExtendedDefinitionText(monitor)))) {
            String definition2 = extendedDefinitionText.trim();
            sql.append("\n");
            sql.append(definition2);
            if (!definition2.endsWith(";")) {
                sql.append(";");
            }
            sql.append("\n");
        }
    }

    @Override
    protected void addOptions(Map<String, Object> options) {
        super.addOptions(options);
        options.put("refresh", true);
        options.put("script.includeDrop", true);
    }
}

