/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseLibrary
extends AltibaseObject<GenericStructContainer>
implements DBPScriptObject,
DBPRefreshableObject {
    private String ddl;
    private String fileSpec;
    private String status;
    private Timestamp created;
    private Timestamp lastDdlTime;

    protected AltibaseLibrary(GenericStructContainer parent, JDBCResultSet resultSet) {
        super(parent, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LIBRARY_NAME"), JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"LIBRARY_ID"), true);
        this.fileSpec = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"FILE_SPEC");
        this.status = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"STATUS");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        this.lastDdlTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_DDL_TIME");
    }

    @Property(viewable=true, order=2)
    public long getLibraryId() {
        return this.getObjectId();
    }

    @Property(viewable=true, order=4)
    @Nullable
    public String getFileSpec() {
        return this.fileSpec;
    }

    @Property(viewable=true, order=5)
    @NotNull
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public Timestamp getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=11)
    @NotNull
    public Timestamp getLastDdlTime() {
        return this.lastDdlTime;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)this.ddl)) {
            this.ddl = this.getDataSource().getMetaModel().getLibraryDDL(monitor, this, options) + ";";
        }
        return this.ddl;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        AltibaseSchema schema = (AltibaseSchema)((Object)this.getParentObject());
        return schema.getLibraryCache().refreshObject(monitor, (DBSObject)schema, this);
    }
}

