/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.oci;

import java.io.File;
import java.io.FilenameFilter;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.ext.oracle.oci.OracleHomeDescriptor;

public class OCIClassLoader
extends ClassLoader {
    private static final Log log = Log.getLog(OCIClassLoader.class);
    private File[] oraHomeLibraries;

    public OCIClassLoader(OracleHomeDescriptor oracleHomeDescriptor, ClassLoader parent) {
        super(parent);
        File dllFolder;
        File oraHomeFile = new File(oracleHomeDescriptor.getName());
        File file = dllFolder = OCIUtils.isInstantClient(oracleHomeDescriptor.getName()) ? oraHomeFile : new File(oraHomeFile, "bin");
        if (dllFolder.exists()) {
            this.oraHomeLibraries = dllFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(System.mapLibraryName(""));
                }
            });
        } else {
            log.warn((Object)("Binary folder isn't found in Oracle home " + oracleHomeDescriptor.getName()));
        }
    }

    @Override
    public String findLibrary(String libname) {
        String nativeName = System.mapLibraryName(libname);
        File[] fileArray = this.oraHomeLibraries;
        int n = this.oraHomeLibraries.length;
        int n2 = 0;
        while (n2 < n) {
            File library = fileArray[n2];
            if (library.getName().equalsIgnoreCase(nativeName)) {
                return library.getAbsolutePath();
            }
            ++n2;
        }
        return super.findLibrary(libname);
    }
}

