/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.nio.charset.StandardCharsets;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class HexValue
extends ASTNodeAccessImpl
implements Expression {
    private String value;

    public HexValue() {
    }

    public HexValue(String value) {
        String val;
        this.value = val = value;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public HexValue withValue(String value) {
        this.setValue(value);
        return this;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getDigits() {
        return this.value.toUpperCase().startsWith("0X") ? this.value.substring(2) : this.value.substring(2, this.value.length() - 1);
    }

    public Long getLong() {
        return Long.parseLong(this.getDigits(), 16);
    }

    public LongValue getLongValue() {
        return new LongValue(this.getLong());
    }

    public StringValue getStringValue() {
        return new StringValue(new String(HexValue.hexStringToByteArray(this.getDigits()), StandardCharsets.UTF_8));
    }

    public StringValue getBlob() {
        StringBuilder builder = new StringBuilder();
        String digits = this.getDigits();
        int len = digits.length();
        for (int i = 0; i < len; i += 2) {
            builder.append("\\x").append(digits.charAt(i)).append(digits.charAt(i + 1));
        }
        return new StringValue(builder.toString());
    }
}

