﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elastictranscoder/ElasticTranscoder_EXPORTS.h>
#include <aws/elastictranscoder/model/Preset.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ElasticTranscoder {
namespace Model {
/**
 * <p>The <code>ListPresetsResponse</code> structure.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elastictranscoder-2012-09-25/ListPresetsResponse">AWS
 * API Reference</a></p>
 */
class ListPresetsResult {
 public:
  AWS_ELASTICTRANSCODER_API ListPresetsResult() = default;
  AWS_ELASTICTRANSCODER_API ListPresetsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ELASTICTRANSCODER_API ListPresetsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of <code>Preset</code> objects.</p>
   */
  inline const Aws::Vector<Preset>& GetPresets() const { return m_presets; }
  template <typename PresetsT = Aws::Vector<Preset>>
  void SetPresets(PresetsT&& value) {
    m_presetsHasBeenSet = true;
    m_presets = std::forward<PresetsT>(value);
  }
  template <typename PresetsT = Aws::Vector<Preset>>
  ListPresetsResult& WithPresets(PresetsT&& value) {
    SetPresets(std::forward<PresetsT>(value));
    return *this;
  }
  template <typename PresetsT = Preset>
  ListPresetsResult& AddPresets(PresetsT&& value) {
    m_presetsHasBeenSet = true;
    m_presets.emplace_back(std::forward<PresetsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A value that you use to access the second and subsequent pages of results, if
   * any. When the presets fit on one page or when you've reached the last page of
   * results, the value of <code>NextPageToken</code> is <code>null</code>.</p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  ListPresetsResult& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListPresetsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Preset> m_presets;

  Aws::String m_nextPageToken;

  Aws::String m_requestId;
  bool m_presetsHasBeenSet = false;
  bool m_nextPageTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticTranscoder
}  // namespace Aws
