/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tomcat.websocket.AsyncChannelWrapper;

public class AsyncChannelWrapperNonSecure
implements AsyncChannelWrapper {
    private static final Future<Void> NOOP_FUTURE = new NoOpFuture();
    private final AsynchronousSocketChannel socketChannel;

    public AsyncChannelWrapperNonSecure(AsynchronousSocketChannel asynchronousSocketChannel) {
        this.socketChannel = asynchronousSocketChannel;
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer) {
        return this.socketChannel.read(byteBuffer);
    }

    @Override
    public <B, A extends B> void read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, B> completionHandler) {
        this.socketChannel.read(byteBuffer, a, completionHandler);
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer) {
        return this.socketChannel.write(byteBuffer);
    }

    @Override
    public <B, A extends B> void write(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, B> completionHandler) {
        this.socketChannel.write(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
    }

    @Override
    public void close() {
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Future<Void> handshake() {
        return NOOP_FUTURE;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socketChannel.getLocalAddress();
    }

    private static final class NoOpFuture
    implements Future<Void> {
        private NoOpFuture() {
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

