/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.backend.panama.ArgumentNode;
import com.oracle.truffle.nfi.backend.panama.ClosureArgumentNode;
import com.oracle.truffle.nfi.backend.panama.ErrorContext;
import com.oracle.truffle.nfi.backend.panama.PanamaClosureFactory;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.panama.PanamaSignature;
import com.oracle.truffle.nfi.backend.panama.PanamaType;
import com.oracle.truffle.nfi.backend.spi.NFIState;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

@ExportLibrary(value=InteropLibrary.class)
final class PanamaClosure
implements TruffleObject {
    final MemorySegment symbol;

    PanamaClosure(MemorySegment symbol) {
        this.symbol = symbol;
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.symbol.address();
    }

    @NodeChild(type=ClosureArgumentNode.class)
    public static final class GenericRetClosureRootNode
    extends PanamaClosureRootNode {
        @Node.Child
        CallClosureNode callClosure;
        @Node.Child
        ArgumentNode toJavaRet;
        @Node.Child
        private InteropLibrary interopLibrary;

        static MonomorphicClosureInfo createInfo(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signature, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            GenericRetClosureRootNode rootNode = new GenericRetClosureRootNode(lang, signature, recvNode);
            return rootNode.createMonomorphicClosureInfo();
        }

        static PolymorphicClosureInfo createInfo(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signature) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signature.argTypes.length);
            GenericRetClosureRootNode rootNode = new GenericRetClosureRootNode(lang, signature, recvNode);
            return rootNode.createPolymorphicClosureInfo();
        }

        private GenericRetClosureRootNode(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super(lang);
            this.callClosure = PanamaClosureFactory.CallClosureNodeGen.create(signature, receiver);
            this.toJavaRet = signature.retType.createArgumentNode();
            this.interopLibrary = (InteropLibrary)InteropLibrary.getFactory().createDispatched(4);
        }

        public Object execute(VirtualFrame frame) {
            PanamaNFILanguage language = PanamaNFILanguage.get((Node)this);
            NFIState nfiState = language.getNFIState();
            ErrorContext ctx = (ErrorContext)language.errorContext.get();
            nfiState.setNFIErrno(ctx.getNativeErrno());
            try {
                Object ret = this.callClosure.execute(frame);
                if (this.interopLibrary.isNull(ret)) {
                    Object object = this.toJavaRet.execute(0);
                    return object;
                }
                Object object = this.toJavaRet.execute(ret);
                return object;
            }
            catch (Throwable t) {
                this.exceptionProfile.enter();
                TruffleStackTrace.fillIn((Throwable)t);
                nfiState.setPendingException(t);
                try {
                    Object object = this.toJavaRet.execute(0);
                    return object;
                }
                catch (UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            finally {
                ctx.setNativeErrno(nfiState.getNFIErrno());
            }
        }
    }

    private static final class VoidRetClosureRootNode
    extends PanamaClosureRootNode {
        @Node.Child
        CallClosureNode callClosure;

        static MonomorphicClosureInfo createInfo(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signatureInfo, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            VoidRetClosureRootNode rootNode = new VoidRetClosureRootNode(lang, signatureInfo, recvNode);
            return rootNode.createMonomorphicClosureInfo();
        }

        static PolymorphicClosureInfo createInfo(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signatureInfo) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            VoidRetClosureRootNode rootNode = new VoidRetClosureRootNode(lang, signatureInfo, recvNode);
            return rootNode.createPolymorphicClosureInfo();
        }

        private VoidRetClosureRootNode(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super(lang);
            this.callClosure = PanamaClosureFactory.CallClosureNodeGen.create(signature, receiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            PanamaNFILanguage language = PanamaNFILanguage.get((Node)this);
            NFIState nfiState = language.getNFIState();
            ErrorContext ctx = (ErrorContext)language.errorContext.get();
            nfiState.setNFIErrno(ctx.getNativeErrno());
            try {
                this.callClosure.execute(frame);
            }
            catch (Throwable t) {
                this.exceptionProfile.enter();
                TruffleStackTrace.fillIn((Throwable)t);
                nfiState.setPendingException(t);
            }
            finally {
                ctx.setNativeErrno(nfiState.getNFIErrno());
            }
            return null;
        }
    }

    private static final class StringRetClosureRootNode
    extends PanamaClosureRootNode {
        @Node.Child
        CallClosureNode callClosure;
        @Node.Child
        private InteropLibrary interopLibrary;
        @Node.Child
        ArgumentNode toJavaRet;

        static MonomorphicClosureInfo createInfo(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signatureInfo, Object receiver) {
            ClosureArgumentNode.ConstArgumentNode recvNode = new ClosureArgumentNode.ConstArgumentNode(receiver);
            StringRetClosureRootNode rootNode = new StringRetClosureRootNode(lang, signatureInfo, recvNode);
            return rootNode.createMonomorphicClosureInfo();
        }

        static PolymorphicClosureInfo createInfo(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signatureInfo) {
            ClosureArgumentNode.GetArgumentNode recvNode = new ClosureArgumentNode.GetArgumentNode(signatureInfo.argTypes.length);
            StringRetClosureRootNode rootNode = new StringRetClosureRootNode(lang, signatureInfo, recvNode);
            return rootNode.createPolymorphicClosureInfo();
        }

        private StringRetClosureRootNode(PanamaNFILanguage lang, PanamaSignature.CachedSignatureInfo signature, ClosureArgumentNode receiver) {
            super(lang);
            this.callClosure = PanamaClosureFactory.CallClosureNodeGen.create(signature, receiver);
            this.toJavaRet = signature.retType.createArgumentNode();
            this.interopLibrary = (InteropLibrary)InteropLibrary.getFactory().createDispatched(4);
        }

        public Object execute(VirtualFrame frame) {
            PanamaNFILanguage language = PanamaNFILanguage.get((Node)this);
            NFIState nfiState = language.getNFIState();
            ErrorContext ctx = (ErrorContext)language.errorContext.get();
            nfiState.setNFIErrno(ctx.getNativeErrno());
            try {
                Object ret = this.callClosure.execute(frame);
                if (this.interopLibrary.isNull(ret)) {
                    Object var6_7 = null;
                    return var6_7;
                }
                Object object = this.toJavaRet.execute(ret);
                return object;
            }
            catch (Throwable t) {
                this.exceptionProfile.enter();
                TruffleStackTrace.fillIn((Throwable)t);
                nfiState.setPendingException(t);
                try {
                    Object object = this.toJavaRet.execute("");
                    return object;
                }
                catch (UnsupportedTypeException ex) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            finally {
                ctx.setNativeErrno(nfiState.getNFIErrno());
            }
        }
    }

    @NodeChild(value="receiver", type=ClosureArgumentNode.class)
    static abstract class CallClosureNode
    extends Node {
        @Node.Children
        final ClosureArgumentNode[] argNodes;

        protected abstract Object execute(VirtualFrame var1);

        CallClosureNode(PanamaSignature.CachedSignatureInfo signature) {
            PanamaType[] args = signature.getArgTypes();
            this.argNodes = new ClosureArgumentNode[args.length];
            for (int i = 0; i < args.length; ++i) {
                ClosureArgumentNode.GetArgumentNode rawArg = new ClosureArgumentNode.GetArgumentNode(i);
                this.argNodes[i] = args[i].createClosureArgumentNode(rawArg);
            }
        }

        @Specialization(limit="3")
        @ExplodeLoop
        Object doCall(VirtualFrame frame, Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            Object[] args = new Object[this.argNodes.length];
            for (int i = 0; i < this.argNodes.length; ++i) {
                args[i] = this.argNodes[i].execute(frame);
            }
            try {
                return interop.execute(receiver, args);
            }
            catch (InteropException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
    }

    static abstract class PanamaClosureRootNode
    extends RootNode {
        static final MethodType METHOD_TYPE = MethodType.methodType(Object.class, Object.class, Object[].class);
        final BranchProfile exceptionProfile = BranchProfile.create();
        static final MethodHandle handle_CallTarget_call;

        PanamaClosureRootNode(PanamaNFILanguage language) {
            super((TruffleLanguage)language);
        }

        MonomorphicClosureInfo createMonomorphicClosureInfo() {
            CompilerAsserts.neverPartOfCompilation();
            RootCallTarget upcallTarget = this.getCallTarget();
            MethodHandle handle = handle_CallTarget_call.bindTo(upcallTarget).asCollector(Object[].class, 2).asType(METHOD_TYPE).asVarargsCollector(Object[].class);
            return new MonomorphicClosureInfo(this, handle);
        }

        PolymorphicClosureInfo createPolymorphicClosureInfo() {
            CompilerAsserts.neverPartOfCompilation();
            RootCallTarget upcallTarget = this.getCallTarget();
            MethodHandle handle = handle_CallTarget_call.bindTo(upcallTarget).asCollector(Object[].class, 2).asType(METHOD_TYPE).asVarargsCollector(Object[].class);
            return new PolymorphicClosureInfo(this, handle);
        }

        static {
            MethodType callType = MethodType.methodType(Object.class, Object[].class);
            try {
                handle_CallTarget_call = MethodHandles.lookup().findVirtual(CallTarget.class, "call", callType);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
    }

    static class PolymorphicClosureInfo
    extends CachedClosureInfo {
        PolymorphicClosureInfo(RootNode rootNode, MethodHandle handle) {
            super(rootNode, handle);
        }

        static PolymorphicClosureInfo create(PanamaSignature.CachedSignatureInfo signatureInfo) {
            CompilerAsserts.neverPartOfCompilation();
            PanamaNFILanguage lang = PanamaNFILanguage.get(null);
            PanamaType retType = signatureInfo.getRetType();
            if (retType.type == NativeSimpleType.STRING) {
                return StringRetClosureRootNode.createInfo(lang, signatureInfo);
            }
            if (retType.type == NativeSimpleType.VOID) {
                return VoidRetClosureRootNode.createInfo(lang, signatureInfo);
            }
            return GenericRetClosureRootNode.createInfo(lang, signatureInfo);
        }
    }

    static class MonomorphicClosureInfo
    extends CachedClosureInfo {
        MonomorphicClosureInfo(RootNode rootNode, MethodHandle handle) {
            super(rootNode, handle);
        }

        static MonomorphicClosureInfo create(PanamaSignature.CachedSignatureInfo signatureInfo, Object executable) {
            CompilerAsserts.neverPartOfCompilation();
            PanamaNFILanguage lang = PanamaNFILanguage.get(null);
            PanamaType retType = signatureInfo.getRetType();
            if (retType.type == NativeSimpleType.STRING) {
                return StringRetClosureRootNode.createInfo(lang, signatureInfo, executable);
            }
            if (retType.type == NativeSimpleType.VOID) {
                return VoidRetClosureRootNode.createInfo(lang, signatureInfo, executable);
            }
            return GenericRetClosureRootNode.createInfo(lang, signatureInfo, executable);
        }
    }

    static abstract class CachedClosureInfo {
        final CallTarget closureCallTarget;
        final MethodHandle handle;

        CachedClosureInfo(RootNode rootNode, MethodHandle handle) {
            this.closureCallTarget = rootNode.getCallTarget();
            this.handle = handle;
        }
    }
}

