/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.runtime.PosixSupportLibrary;

public abstract class TimeUtils {
    public static final long SEC_TO_MS = 1000L;
    public static final long MS_TO_US = 1000L;
    public static final long SEC_TO_US = 1000000L;
    public static final long US_TO_NS = 1000L;
    public static final long MS_TO_NS = 1000000L;
    public static final long SEC_TO_NS = 1000000000L;

    public static PosixSupportLibrary.Timeval pyTimeAsTimeval(long t) {
        long secs = t / 1000000000L;
        long ns = t % 1000000000L;
        long usec = TimeUtils.pyTimeDivide(ns, 1000L);
        if (usec < 0L) {
            usec += 1000000L;
            --secs;
        } else if (usec >= 1000000L) {
            usec -= 1000000L;
            ++secs;
        }
        assert (0L <= usec && usec < 1000000L);
        return new PosixSupportLibrary.Timeval(secs, usec);
    }

    public static long pyTimeDivide(long t, long k) {
        assert (k > 1L);
        if (t >= 0L) {
            return (t + k - 1L) / k;
        }
        return (t - (k - 1L)) / k;
    }

    public static double pyTimeAsSecondsDouble(long t) {
        double d;
        if (t % 1000000000L == 0L) {
            long secs = t / 1000000000L;
            d = secs;
        } else {
            d = t;
            d /= 1.0E9;
        }
        return d;
    }
}

