/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler.bytecode_dsl;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.compiler.Compiler;
import com.oracle.graal.python.compiler.ParserCallbacksImpl;
import com.oracle.graal.python.compiler.bytecode_dsl.RootNodeCompiler;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLCodeUnit;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.scope.Scope;
import com.oracle.graal.python.pegparser.scope.ScopeEnvironment;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.source.Source;
import java.util.EnumSet;

public class BytecodeDSLCompiler {
    public static BytecodeDSLCompilerResult compile(PythonLanguage language, PythonContext context, ModTy mod, Source source, int optimize, ParserCallbacksImpl parserCallbacks, EnumSet<FutureFeature> futureFeatures) {
        int futureLineNumber = BytecodeDSLCompiler.parseFuture(mod, futureFeatures, parserCallbacks);
        ScopeEnvironment scopeEnvironment = ScopeEnvironment.analyze(mod, parserCallbacks, futureFeatures);
        BytecodeDSLCompilerContext ctx = new BytecodeDSLCompilerContext(language, context, mod, source, optimize, futureFeatures, futureLineNumber, parserCallbacks, scopeEnvironment);
        RootNodeCompiler compiler = new RootNodeCompiler(ctx, null, mod, futureFeatures);
        return compiler.compile();
    }

    private static int parseFuture(ModTy mod, EnumSet<FutureFeature> futureFeatures, ParserCallbacksImpl parserCallbacks) {
        StmtTy[] stmts = null;
        if (mod instanceof ModTy.Module) {
            ModTy.Module module = (ModTy.Module)mod;
            stmts = module.body;
        } else if (mod instanceof ModTy.Interactive) {
            ModTy.Interactive interactive = (ModTy.Interactive)mod;
            stmts = interactive.body;
        } else {
            return -1;
        }
        return Compiler.parseFuture(stmts, futureFeatures, parserCallbacks);
    }

    public static class BytecodeDSLCompilerContext {
        public final PythonLanguage language;
        public final PythonContext pythonContext;
        public final ModTy mod;
        public final Source source;
        public final int optimizationLevel;
        public final EnumSet<FutureFeature> futureFeatures;
        public final int futureLineNumber;
        public final ParserCallbacksImpl errorCallback;
        public final ScopeEnvironment scopeEnvironment;

        public BytecodeDSLCompilerContext(PythonLanguage language, PythonContext context, ModTy mod, Source source, int optimizationLevel, EnumSet<FutureFeature> futureFeatures, int futureLineNumber, ParserCallbacksImpl errorCallback, ScopeEnvironment scopeEnvironment) {
            this.language = language;
            this.pythonContext = context;
            this.mod = mod;
            this.source = source;
            this.optimizationLevel = optimizationLevel;
            this.futureFeatures = futureFeatures;
            this.futureLineNumber = futureLineNumber;
            this.errorCallback = errorCallback;
            this.scopeEnvironment = scopeEnvironment;
        }

        public String maybeMangle(String privateName, Scope scope, String name) {
            return ScopeEnvironment.maybeMangle(privateName, scope, name);
        }

        String mangle(Scope scope, String name) {
            return ScopeEnvironment.mangle(this.getClassName(scope), name);
        }

        String getClassName(Scope s) {
            Scope cur = s;
            while (cur != null) {
                if (cur.isClass()) {
                    return cur.getName();
                }
                cur = this.scopeEnvironment.lookupParent(cur);
            }
            return null;
        }
    }

    public record BytecodeDSLCompilerResult(PBytecodeDSLRootNode rootNode, BytecodeDSLCodeUnit codeUnit) {
    }
}

