/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableSequence;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;

final class SequenceRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SequenceRetriever.class.getName());

    SequenceRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveSequenceInformation(InclusionRule sequenceInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableSequence> sequenceFilter = new InclusionRuleFilter<MutableSequence>(sequenceInclusionRule, false);
        if (sequenceFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving sequences, since this was not requested");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving sequences");
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SEQUENCES)) {
            LOGGER.log(Level.FINE, "Sequence definition SQL statement was not provided");
            return;
        }
        Query sequencesDefinitionSql = informationSchemaViews.getQuery(InformationSchemaKey.SEQUENCES);
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        String name = "sequences";
        RetrievalCounts retrievalCounts = new RetrievalCounts("sequences");
        try (Connection connection = this.getRetrieverConnection().getConnection("sequences");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(sequencesDefinitionSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("SEQUENCE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("SEQUENCE_SCHEMA"));
                String sequenceName = results.getString("SEQUENCE_NAME");
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                if (!schemas.contains(schema)) continue;
                MutableSequence sequence = new MutableSequence(schema, sequenceName);
                sequence.withQuoting(this.getRetrieverConnection().getIdentifiers());
                if (!sequenceFilter.test(sequence)) continue;
                BigInteger startValue = results.getBigInteger("START_VALUE");
                BigInteger minimumValue = results.getBigInteger("MINIMUM_VALUE");
                BigInteger maximumValue = results.getBigInteger("MAXIMUM_VALUE");
                BigInteger increment = results.getBigInteger("INCREMENT");
                long longIncrement = increment == null ? 1L : increment.longValue();
                boolean cycle = results.getBoolean("CYCLE_OPTION");
                sequence.setStartValue(startValue);
                sequence.setMaximumValue(maximumValue);
                sequence.setMinimumValue(minimumValue);
                sequence.setIncrement(longIncrement);
                sequence.setCycle(cycle);
                sequence.addAttributes(results.getAttributes());
                this.catalog.addSequence(sequence);
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve sequences", e);
        }
        retrievalCounts.log();
    }
}

