/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.inclusionrule;

import java.util.Objects;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.inclusionrule.RegularExpressionRule;

public final class RegularExpressionExclusionRule
implements InclusionRuleWithRegularExpression {
    private static final long serialVersionUID = 6274652266761961575L;
    private final InclusionRule inclusionRule;

    public RegularExpressionExclusionRule(Pattern patternExclude) {
        this.inclusionRule = patternExclude == null ? new IncludeAll() : new RegularExpressionRule(null, patternExclude);
    }

    public RegularExpressionExclusionRule(String patternExclude) {
        this(patternExclude == null ? null : Pattern.compile(patternExclude));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InclusionRuleWithRegularExpression)) {
            return false;
        }
        InclusionRuleWithRegularExpression other = (InclusionRuleWithRegularExpression)obj;
        return this.getExclusionPattern().pattern().equals(other.getExclusionPattern().pattern()) && this.getInclusionPattern().pattern().equals(other.getInclusionPattern().pattern());
    }

    @Override
    public Pattern getExclusionPattern() {
        InclusionRule inclusionRule = this.inclusionRule;
        if (inclusionRule instanceof InclusionRuleWithRegularExpression) {
            InclusionRuleWithRegularExpression expression = (InclusionRuleWithRegularExpression)inclusionRule;
            return expression.getExclusionPattern();
        }
        return InclusionRuleWithRegularExpression.super.getExclusionPattern();
    }

    @Override
    public Pattern getInclusionPattern() {
        InclusionRule inclusionRule = this.inclusionRule;
        if (inclusionRule instanceof InclusionRuleWithRegularExpression) {
            InclusionRuleWithRegularExpression expression = (InclusionRuleWithRegularExpression)inclusionRule;
            return expression.getInclusionPattern();
        }
        return InclusionRuleWithRegularExpression.super.getInclusionPattern();
    }

    public int hashCode() {
        return Objects.hash(this.getExclusionPattern().pattern(), this.getInclusionPattern().pattern());
    }

    @Override
    public boolean test(String text) {
        return this.inclusionRule.test(text);
    }

    public String toString() {
        return this.inclusionRule.toString();
    }
}

