/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.GrepOptions;
import us.fatehi.utility.string.StringFormat;

class TableGrepFilter
implements Predicate<Table> {
    private static final Logger LOGGER = Logger.getLogger(TableGrepFilter.class.getName());
    private final GrepOptions options;

    public TableGrepFilter(GrepOptions options) {
        this.options = Objects.requireNonNull(options, "No grep options provided");
    }

    @Override
    public boolean test(Table table) {
        boolean include;
        boolean checkIncludeForTables = this.options.isGrepTables();
        boolean checkIncludeForColumns = this.options.isGrepColumns();
        boolean checkIncludeForDefinitions = this.options.isGrepDefinitions();
        if (!(checkIncludeForTables || checkIncludeForColumns || checkIncludeForDefinitions)) {
            if (this.options.grepInvertMatch()) {
                LOGGER.log(Level.FINE, new StringFormat("Ignoring the invert match setting for table <%s>, since no inclusion rules are set", table));
            }
            return true;
        }
        boolean includeForTables = this.checkIncludeForTables(table);
        boolean includeForColumns = this.checkIncludeForColumns(table);
        boolean includeForDefinitions = this.checkIncludeForDefinitions(table);
        boolean bl = include = checkIncludeForTables && includeForTables || checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.options.grepInvertMatch()) {
            boolean bl2 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, new StringFormat("Excluding table <%s>", table));
        }
        return include;
    }

    private boolean checkIncludeForColumns(Table table) {
        InclusionRule grepColumnInclusionRule = this.options.grepColumnInclusionRule();
        List<Column> columns = table.getColumns();
        if (columns.isEmpty()) {
            return true;
        }
        for (Column column : columns) {
            if (grepColumnInclusionRule == null || !grepColumnInclusionRule.test(column.getFullName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkIncludeForDefinitions(Table table) {
        InclusionRule grepDefinitionInclusionRule = this.options.grepDefinitionInclusionRule();
        if (grepDefinitionInclusionRule != null) {
            if (grepDefinitionInclusionRule.test(table.getRemarks()) || grepDefinitionInclusionRule.test(table.getDefinition())) {
                return true;
            }
            for (Trigger trigger : table.getTriggers()) {
                if (!grepDefinitionInclusionRule.test(trigger.getActionStatement())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIncludeForTables(Table table) {
        return this.options.isGrepTables() && this.options.grepTableInclusionRule().test(table.getFullName());
    }
}

