/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodes;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TStringUnsafe;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.provider.JCodingsProvider;

final class JCodingsImpl
implements JCodings {
    private final JCodingsProvider provider;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JCodingsProvider.Encoding[] jcodingsEncodings;
    private static final byte[] CONVERSION_REPLACEMENT;
    private static final byte[] CONVERSION_REPLACEMENT_UTF_16;
    private static final byte[] CONVERSION_REPLACEMENT_UTF_32;

    JCodingsImpl(JCodingsProvider provider) {
        this.provider = provider;
        TruffleString.Encoding[] encodingValues = TruffleString.Encoding.values();
        this.jcodingsEncodings = new JCodingsProvider.Encoding[encodingValues.length];
        for (TruffleString.Encoding e : encodingValues) {
            JCodingsProvider.Encoding jcodingsEncoding;
            this.jcodingsEncodings[e.id] = jcodingsEncoding = provider.get(e.jCodingName);
            assert (jcodingsEncoding.isSingleByte() == e.isSingleByte()) : e;
        }
    }

    private JCodingsProvider.Encoding get(TruffleString.Encoding encoding) {
        return this.jcodingsEncodings[encoding.id];
    }

    @Override
    public int minLength(TruffleString.Encoding encoding) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return this.get(encoding).minLength();
    }

    @Override
    public int maxLength(TruffleString.Encoding encoding) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return this.get(encoding).maxLength();
    }

    @Override
    public boolean isFixedWidth(TruffleString.Encoding encoding) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        JCodingsProvider.Encoding jCoding = this.get(encoding);
        return jCoding.isFixedWidth() && jCoding.isSingleByte();
    }

    @Override
    public boolean isSingleByte(TruffleString.Encoding encoding) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return this.get(encoding).isSingleByte();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getCodePointLength(TruffleString.Encoding encoding, int codepoint) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return this.get(encoding).codeToMbcLength(codepoint);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getPreviousCodePointIndex(TruffleString.Encoding encoding, byte[] array, int arrayBegin, int index, int arrayEnd) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return this.get(encoding).prevCharHead(array, arrayBegin, index, arrayEnd);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getCodePointLength(TruffleString.Encoding encoding, byte[] array, int index, int arrayLength) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return this.get(encoding).length(array, index, arrayLength);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int readCodePoint(TruffleString.Encoding encoding, byte[] array, int index, int arrayEnd, DecodingErrorHandler errorHandler) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        JCodingsProvider.Encoding jCoding = this.get(encoding);
        int codePoint = jCoding.mbcToCode(array, index, arrayEnd);
        if (jCoding.isUnicode() && Encodings.isUTF16Surrogate(codePoint)) {
            return TStringGuards.isReturnNegative(errorHandler) ? -1 : Encodings.invalidCodepoint();
        }
        return codePoint;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isValidCodePoint(TruffleString.Encoding encoding, int codepoint) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return !this.get(encoding).isUnicode() || !Encodings.isUTF16Surrogate(codepoint);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int writeCodePoint(TruffleString.Encoding encoding, int codepoint, byte[] array, int index) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        return this.get(encoding).codeToMbc(codepoint, array, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int codePointIndexToRaw(Node location, AbstractTruffleString a, byte[] arrayA, int extraOffsetRaw, int index, boolean isLength, TruffleString.Encoding encoding) {
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        JCodingsProvider.Encoding jCoding = this.get(encoding);
        int minLength = jCoding.minLength();
        if (jCoding.isFixedWidth()) {
            return index * minLength;
        }
        int offset = a.byteArrayOffset() + extraOffsetRaw;
        int end = a.byteArrayOffset() + a.length();
        int cpi = 0;
        int i = 0;
        int regionLength = a.length() - extraOffsetRaw;
        while (i < regionLength) {
            if (cpi == index) {
                return i;
            }
            int length = jCoding.length(arrayA, offset + i, end);
            if (length < 1) {
                if (length < -1) {
                    if (isLength) {
                        return regionLength;
                    }
                    throw InternalErrors.indexOutOfBounds(regionLength, index);
                }
                i += minLength;
            } else {
                i += length;
            }
            TStringConstants.truffleSafePointPoll(location, ++cpi);
        }
        return TStringInternalNodes.CodePointIndexToRawNode.atEnd(a, extraOffsetRaw, index, isLength, cpi);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int decode(AbstractTruffleString a, byte[] arrayA, int rawIndex, TruffleString.Encoding encoding, TruffleString.ErrorHandling errorHandling) {
        int end;
        assert (TStringGuards.isUnsupportedEncoding(encoding));
        int p = a.byteArrayOffset() + rawIndex;
        int length = this.getCodePointLength(encoding, arrayA, p, end = a.byteArrayOffset() + a.length());
        if (length < 1) {
            return Encodings.invalidCodepointReturnValue(errorHandling);
        }
        return this.readCodePoint(encoding, arrayA, p, end, errorHandling.errorHandler);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long calcStringAttributes(Node location, AbstractTruffleString a, byte[] arrayA, long offsetA, int lengthA, TruffleString.Encoding encodingA, int fromIndexA) {
        int offsetBytes;
        byte[] bytes;
        assert (TStringGuards.isUnsupportedEncoding(encodingA));
        if (TStringGuards.is7BitCompatible(encodingA) && TStringOps.calcStringAttributesLatin1(location, arrayA, offsetA + (long)fromIndexA, lengthA) == TSCodeRange.get7Bit()) {
            return StringAttributes.create(lengthA, TSCodeRange.get7Bit());
        }
        if (arrayA == null) {
            if (a == null) {
                bytes = new byte[lengthA];
                TStringUnsafe.copyFromNative(offsetA, 0, bytes, 0L, lengthA);
            } else {
                bytes = ((AbstractTruffleString.NativePointer)a.data()).materializeByteArray(a);
            }
            offsetBytes = fromIndexA;
        } else {
            bytes = arrayA;
            offsetBytes = (int)(offsetA - (long)TStringUnsafe.byteArrayBaseOffset() + (long)fromIndexA);
        }
        JCodingsProvider.Encoding enc = this.get(encodingA);
        int codeRange = TSCodeRange.getValid(enc.isSingleByte());
        int characters = 0;
        int p = offsetBytes;
        int end = offsetBytes + lengthA;
        int loopCount = 0;
        while (p < end) {
            int lengthOfCurrentCharacter = enc.length(bytes, p, end);
            if (lengthOfCurrentCharacter > 0 && p + lengthOfCurrentCharacter <= end) {
                p += lengthOfCurrentCharacter;
            } else {
                codeRange = TSCodeRange.getBroken(enc.isSingleByte());
                if (enc.isFixedWidth()) {
                    characters = (lengthA + enc.minLength() - 1) / enc.minLength();
                    return StringAttributes.create(characters, codeRange);
                }
                p += enc.minLength();
            }
            TStringConstants.truffleSafePointPoll(location, ++loopCount);
            ++characters;
        }
        return StringAttributes.create(characters, codeRange);
    }

    private static byte[] getConversionReplacement(TruffleString.Encoding targetEncoding) {
        if (TStringGuards.isUTF8(targetEncoding)) {
            return Encodings.CONVERSION_REPLACEMENT_UTF_8;
        }
        if (TStringGuards.isUTF16(targetEncoding)) {
            return CONVERSION_REPLACEMENT_UTF_16;
        }
        if (TStringGuards.isUTF32(targetEncoding)) {
            return CONVERSION_REPLACEMENT_UTF_32;
        }
        return CONVERSION_REPLACEMENT;
    }

    private static JCodingsProvider.Encoding getBytesEncoding(AbstractTruffleString a) {
        JCodingsImpl impl = (JCodingsImpl)JCodings.getInstance();
        if (TStringGuards.isUTF16Or32(a.encoding()) && TStringGuards.isStride0(a)) {
            return impl.get(TruffleString.Encoding.ISO_8859_1);
        }
        if (TStringGuards.isUTF32(a.encoding()) && TStringGuards.isStride1(a)) {
            return impl.get(TruffleString.Encoding.UTF_16);
        }
        return impl.get(TruffleString.Encoding.get(a.encoding()));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString transcode(Node location, AbstractTruffleString a, byte[] arrayA, int codePointLengthA, TruffleString.Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
        JCodingsProvider.Encoding jCodingSrc = JCodingsImpl.getBytesEncoding(a);
        JCodingsProvider.Encoding jCodingDst = this.get(targetEncoding);
        byte[] replacement = JCodingsImpl.getConversionReplacement(targetEncoding);
        JCodingsProvider.TranscodeResult result = this.provider.transcode(a, codePointLengthA, a.byteArrayOffset(), a.length() << a.stride(), targetEncoding, jCodingSrc, jCodingDst, replacement, errorHandler, JCodingsImpl::asBytesMaterializeNative, JCodingsImpl::getBytesEncoding);
        AbstractTruffleString.checkArrayRange(result.buffer(), 0, result.length());
        return TStringInternalNodesFactory.FromBufferWithStringCompactionNodeGen.getUncached().execute(location, result.buffer(), 0, result.length(), targetEncoding, result.length() != result.buffer().length || targetEncoding.isSupported(), TStringGuards.isBroken(a.codeRange()) || result.undefinedConversion() || a.isMutable());
    }

    private static byte[] asBytesMaterializeNative(AbstractTruffleString replacementString) {
        Object dataA = TStringInternalNodes.ToIndexableNode.getUncached().execute(null, replacementString, replacementString.data());
        if (dataA instanceof AbstractTruffleString.NativePointer) {
            AbstractTruffleString.NativePointer nativePointer = (AbstractTruffleString.NativePointer)dataA;
            return nativePointer.materializeByteArray(replacementString);
        }
        return (byte[])dataA;
    }

    static {
        byte[] byArray;
        byte[] byArray2;
        CONVERSION_REPLACEMENT = new byte[]{63};
        if (TStringGuards.littleEndian()) {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray2 = byArray3;
            byArray3[1] = -1;
        } else {
            byte[] byArray4 = new byte[2];
            byArray4[0] = -1;
            byArray2 = byArray4;
            byArray4[1] = -3;
        }
        CONVERSION_REPLACEMENT_UTF_16 = byArray2;
        if (TStringGuards.littleEndian()) {
            byte[] byArray5 = new byte[4];
            byArray5[0] = -3;
            byArray5[1] = -1;
            byArray5[2] = 0;
            byArray = byArray5;
            byArray5[3] = 0;
        } else {
            byte[] byArray6 = new byte[4];
            byArray6[0] = 0;
            byArray6[1] = 0;
            byArray6[2] = -1;
            byArray = byArray6;
            byArray6[3] = -3;
        }
        CONVERSION_REPLACEMENT_UTF_32 = byArray;
    }
}

