/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.arrow;

import com.oracle.graal.python.nodes.arrow.capsule.ArrowArrayCapsuleDestructor;
import com.oracle.graal.python.nodes.arrow.capsule.ArrowSchemaCapsuleDestructor;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.arrow.ArrowUtil;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.nfi.api.SignatureLibrary;

public class ArrowSupport {
    protected final PythonContext ctx;
    private Object arrowArrayDestructorNFIClosure;
    @CompilerDirectives.CompilationFinal
    private long arrowArrayDestructor;
    private Object arrowSchemaDestructorNFIClosure;
    @CompilerDirectives.CompilationFinal
    private long arrowSchemaDestructor;

    public ArrowSupport(PythonContext ctx) {
        this.ctx = ctx;
    }

    public long getArrowSchemaDestructor() {
        if (this.arrowSchemaDestructor == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initArrowSchemaDestructor();
        }
        return this.arrowSchemaDestructor;
    }

    public long getArrowArrayDestructor() {
        if (this.arrowArrayDestructor == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initArrowArrayDestructor();
        }
        return this.arrowArrayDestructor;
    }

    @CompilerDirectives.TruffleBoundary
    private void initArrowArrayDestructor() {
        CompilerAsserts.neverPartOfCompilation();
        Object signature = ArrowUtil.createNfiSignature("(POINTER):VOID", this.ctx);
        ArrowArrayCapsuleDestructor executable = new ArrowArrayCapsuleDestructor();
        this.arrowArrayDestructorNFIClosure = SignatureLibrary.getUncached().createClosure(signature, (Object)executable);
        this.arrowArrayDestructor = PythonUtils.coerceToLong(this.arrowArrayDestructorNFIClosure, InteropLibrary.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    private void initArrowSchemaDestructor() {
        CompilerAsserts.neverPartOfCompilation();
        Object signature = ArrowUtil.createNfiSignature("(POINTER):VOID", this.ctx);
        ArrowSchemaCapsuleDestructor executable = new ArrowSchemaCapsuleDestructor();
        this.arrowSchemaDestructorNFIClosure = SignatureLibrary.getUncached().createClosure(signature, (Object)executable);
        this.arrowSchemaDestructor = PythonUtils.coerceToLong(this.arrowSchemaDestructorNFIClosure, InteropLibrary.getUncached());
    }
}

