/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.tokenizer;

public final class SourceRange {
    public static final SourceRange ARTIFICIAL_RANGE = new SourceRange(1, 0, 1, 0);
    public final int startLine;
    public final int startColumn;
    public final int endLine;
    public final int endColumn;

    public SourceRange(int startLine, int startColumn, int endLine, int endColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public SourceRange withEnd(SourceRange end) {
        return this.withEnd(end.endLine, end.endColumn);
    }

    public SourceRange withEnd(int newEndLine, int newEndColumn) {
        return new SourceRange(this.startLine, this.startColumn, newEndLine, newEndColumn);
    }

    public SourceRange shiftStartRight(int columns) {
        assert (columns >= 0);
        if (columns == 0) {
            return this;
        }
        return new SourceRange(this.startLine, this.startColumn + columns, this.endLine, this.endColumn);
    }

    public SourceRange shiftEndRight(int columns) {
        assert (columns >= 0);
        if (columns == 0) {
            return this;
        }
        return new SourceRange(this.startLine, this.startColumn, this.endLine, this.endColumn + columns);
    }
}

