/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNodeGen;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
@GenerateInline(value=false)
public abstract class WriteAttributeToObjectNode
extends PNodeWithContext {
    public abstract boolean execute(Object var1, TruffleString var2, Object var3);

    @NeverDefault
    public static WriteAttributeToObjectNode create() {
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.create();
    }

    @NeverDefault
    public static WriteAttributeToObjectNode create(boolean forceType) {
        if (forceType) {
            return WriteAttributeToObjectNodeGen.WriteAttributeToObjectTpDictNodeGen.create();
        }
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.create();
    }

    @NeverDefault
    public static WriteAttributeToObjectNode createForceType() {
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectTpDictNodeGen.create();
    }

    public static WriteAttributeToObjectNode getUncached() {
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.getUncached();
    }

    public static WriteAttributeToObjectNode getUncached(boolean forceType) {
        if (forceType) {
            return WriteAttributeToObjectNodeGen.WriteAttributeToObjectTpDictNodeGen.getUncached();
        }
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.getUncached();
    }

    protected static boolean isAttrWritable(PythonObject self) {
        return (self.getShape().getFlags() & 2) == 0;
    }

    protected static boolean writeToDynamicStorageNoTypeGuard(Object obj, GetDictIfExistsNode getDict) {
        return getDict.execute(obj) == null && !PythonManagedClass.isInstance(obj);
    }

    @Specialization(guards={"isAttrWritable(object)", "writeToDynamicStorageNoTypeGuard(object, getDict)"})
    static boolean writeToDynamicStorageNoType(PythonObject object, TruffleString key, Object value, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached WriteAttributeToPythonObjectNode writeNode) {
        writeNode.execute(object, key, value);
        return true;
    }

    @Specialization(guards={"isAttrWritable(klass)", "getDict.execute(klass) == null"})
    boolean writeToDynamicStorageBuiltinType(PythonBuiltinClass klass, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Shared(value="callAttrUpdate") @Cached InlinedBranchProfile callAttrUpdate, @Cached.Shared(value="dylib") @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") DynamicObjectLibrary dylib, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (PythonContext.get(this).isInitialized()) {
            throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, key, klass);
        }
        return WriteAttributeToObjectNode.writeToDynamicStorageManagedClass(klass, key, value, inliningTarget, callAttrUpdate, dylib, codePointLengthNode, codePointAtIndexNode);
    }

    @Specialization(guards={"isAttrWritable(klass)", "getDict.execute(klass) == null"})
    static boolean writeToDynamicStoragePythonClass(PythonClass klass, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Exclusive @Cached InlinedBranchProfile callAttrUpdate, @Cached.Exclusive @Cached InlinedBranchProfile updateFlags, @Cached.Shared(value="dylib") @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") DynamicObjectLibrary dylib, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (value == PNone.NO_VALUE) {
            updateFlags.enter(inliningTarget);
            dylib.setShapeFlags((DynamicObject)klass, dylib.getShapeFlags((DynamicObject)klass) | 4);
        }
        return WriteAttributeToObjectNode.writeToDynamicStorageManagedClass(klass, key, value, inliningTarget, callAttrUpdate, dylib, codePointLengthNode, codePointAtIndexNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeToDynamicStorageManagedClass(PythonManagedClass klass, TruffleString key, Object value, Node inliningTarget, InlinedBranchProfile callAttrUpdate, DynamicObjectLibrary dylib, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        CompilerAsserts.partialEvaluationConstant(klass.getClass());
        try {
            dylib.put((DynamicObject)klass, (Object)key, value);
            boolean bl = true;
            return bl;
        }
        finally {
            if (!klass.canSkipOnAttributeUpdate(key, value, codePointLengthNode, codePointAtIndexNode)) {
                callAttrUpdate.enter(inliningTarget);
                klass.onAttributeUpdate(key, value);
            }
        }
    }

    @Specialization(guards={"dict != null", "!isManagedClass(object)", "!isNoValue(value)"})
    static boolean writeToDictNoType(PythonObject object, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(object)") PDict dict, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem) {
        return WriteAttributeToObjectNode.writeToDict(dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
    }

    @Specialization(guards={"dict != null", "!isNoValue(value)"})
    boolean writeToDictBuiltinType(PythonBuiltinClass klass, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(klass)") PDict dict, @Cached.Shared(value="callAttrUpdate") @Cached InlinedBranchProfile callAttrUpdate, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (PythonContext.get(this).isInitialized()) {
            throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, PyObjectReprAsTruffleStringNode.executeUncached(key), klass);
        }
        return WriteAttributeToObjectNode.writeToDictManagedClass(klass, dict, key, value, inliningTarget, callAttrUpdate, updateStorage, setHashingStorageItem, codePointLengthNode, codePointAtIndexNode);
    }

    @Specialization(guards={"dict != null", "!isNoValue(value)"})
    static boolean writeToDictClass(PythonClass klass, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(klass)") PDict dict, @Cached.Shared(value="callAttrUpdate") @Cached InlinedBranchProfile callAttrUpdate, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        return WriteAttributeToObjectNode.writeToDictManagedClass(klass, dict, key, value, inliningTarget, callAttrUpdate, updateStorage, setHashingStorageItem, codePointLengthNode, codePointAtIndexNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"dict != null", "isNoValue(value)", "!isPythonBuiltinClass(obj)"})
    static boolean deleteFromPythonObject(PythonObject obj, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(obj)") PDict dict, @Cached.Exclusive @Cached InlinedBranchProfile callAttrUpdate, @Cached HashingStorageNodes.HashingStorageDelItem hashingStorageDelItem, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        try {
            HashingStorage dictStorage = dict.getDictStorage();
            boolean bl = hashingStorageDelItem.execute(inliningTarget, dictStorage, key, dict);
            return bl;
        }
        finally {
            PythonManagedClass klass;
            if (obj instanceof PythonManagedClass && !(klass = (PythonManagedClass)obj).canSkipOnAttributeUpdate(key, value, codePointLengthNode, codePointAtIndexNode)) {
                callAttrUpdate.enter(inliningTarget);
                klass.onAttributeUpdate(key, value);
            }
        }
    }

    @Specialization(guards={"dict != null", "isNoValue(value)"})
    static boolean deleteFromPythonBuiltinClass(PythonBuiltinClass klass, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(klass)") PDict dict) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, key, klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeToDictManagedClass(PythonManagedClass klass, PDict dict, TruffleString key, Object value, Node inliningTarget, InlinedBranchProfile callAttrUpdate, InlinedBranchProfile updateStorage, HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        CompilerAsserts.partialEvaluationConstant(klass.getClass());
        try {
            boolean bl = WriteAttributeToObjectNode.writeToDict(dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
            return bl;
        }
        finally {
            if (!klass.canSkipOnAttributeUpdate(key, value, codePointLengthNode, codePointAtIndexNode)) {
                callAttrUpdate.enter(inliningTarget);
                klass.onAttributeUpdate(key, value);
            }
        }
    }

    static boolean writeToDict(PDict dict, TruffleString key, Object value, Node inliningTarget, InlinedBranchProfile updateStorage, HashingStorageNodes.HashingStorageSetItem setHashingStorageItem) {
        HashingStorage hashingStorage;
        assert (dict != null);
        HashingStorage dictStorage = dict.getDictStorage();
        if (dictStorage != (hashingStorage = setHashingStorageItem.execute(null, inliningTarget, dictStorage, key, value))) {
            updateStorage.enter(inliningTarget);
            dict.setDictStorage(hashingStorage);
        }
        return true;
    }

    @Specialization
    static boolean doPBCT(PythonBuiltinClassType object, TruffleString key, Object value, @Cached WriteAttributeToObjectNode recursive) {
        return recursive.execute(PythonContext.get(recursive).lookupType(object), key, value);
    }

    protected static boolean isErrorCase(GetDictIfExistsNode getDict, Object object) {
        if (object instanceof PythonObject) {
            PythonObject self = (PythonObject)object;
            if (WriteAttributeToObjectNode.isAttrWritable(self) && getDict.execute(self) == null) {
                return false;
            }
            if (getDict.execute(self) != null) {
                return false;
            }
        }
        if (object instanceof PythonAbstractNativeObject) {
            return false;
        }
        return !(object instanceof PythonBuiltinClassType);
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class WriteAttributeToObjectNotTypeNode
    extends WriteAttributeToObjectNode {
        protected WriteAttributeToObjectNotTypeNode() {
        }

        @Specialization
        static boolean writeNativeObject(PythonAbstractNativeObject object, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached PRaiseNode raiseNode) {
            PDict dict = getDict.execute(object);
            if (dict != null) {
                return WriteAttributeToObjectNotTypeNode.writeToDict(dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }

        @Specialization(guards={"isErrorCase(getDict, object)"})
        static boolean doError(Object object, TruffleString key, Object value, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={TpSlots.class})
    protected static abstract class WriteAttributeToObjectTpDictNode
    extends WriteAttributeToObjectNode {
        protected WriteAttributeToObjectTpDictNode() {
        }

        private static void checkNativeImmutable(Node inliningTarget, PythonAbstractNativeObject object, TruffleString key, CStructAccess.ReadI64Node getNativeFlags, PRaiseNode raiseNode) {
            long flags = getNativeFlags.readFromObj(object, CFields.PyTypeObject__tp_flags);
            if ((flags & 0x100L) != 0L) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, key, object);
            }
        }

        @Specialization(guards={"!canBeSpecialMethod(key, codePointLengthNode, codePointAtIndexNode)"})
        static boolean writeNativeClassSimple(PythonAbstractNativeObject object, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached CStructAccess.ReadI64Node getNativeFlags, @Cached.Shared @Cached CStructAccess.ReadObjectNode getNativeDict, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            WriteAttributeToObjectTpDictNode.checkNativeImmutable(inliningTarget, object, key, getNativeFlags, raiseNode);
            Object dict = getNativeDict.readFromObj(object, CFields.PyTypeObject__tp_dict);
            if (dict instanceof PDict) {
                return WriteAttributeToObjectTpDictNode.writeToDict((PDict)dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }

        @Specialization(replaces={"writeNativeClassSimple"})
        static boolean writeNativeClassGeneric(PythonAbstractNativeObject object, TruffleString key, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached CStructAccess.ReadI64Node getNativeFlags, @Cached.Shared @Cached CStructAccess.ReadObjectNode getNativeDict, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Exclusive @Cached InlinedBranchProfile updateStorage, @Cached.Exclusive @Cached InlinedBranchProfile canBeSpecialSlot, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            try {
                WriteAttributeToObjectTpDictNode.checkNativeImmutable(inliningTarget, object, key, getNativeFlags, raiseNode);
                Object dict = getNativeDict.readFromObj(object, CFields.PyTypeObject__tp_dict);
                if (dict instanceof PDict) {
                    boolean bl = WriteAttributeToObjectTpDictNode.writeToDict((PDict)dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
                    return bl;
                }
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
            }
            finally {
                if (TpSlots.canBeSpecialMethod(key, codePointLengthNode, codePointAtIndexNode)) {
                    canBeSpecialSlot.enter(inliningTarget);
                    if (isTypeNode.execute(inliningTarget, object)) {
                        TpSlots.updateSlot((PythonAbstractClass)object, key);
                    }
                }
            }
        }

        @Specialization(guards={"isErrorCase(getDict, object)"})
        static boolean doError(Object object, TruffleString key, Object value, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }
    }
}

