/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument.keywords;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNodeGen;
import com.oracle.graal.python.nodes.argument.keywords.MappingToKeywordsNode;
import com.oracle.graal.python.nodes.argument.keywords.NonMappingException;
import com.oracle.graal.python.nodes.argument.keywords.SameDictKeyException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class ExpandKeywordStarargsNode
extends PNodeWithContext {
    public abstract PKeyword[] execute(VirtualFrame var1, Node var2, Object var3);

    public final PKeyword[] executeCached(Object starargs) {
        return this.execute(null, this, starargs);
    }

    public final PKeyword[] execute(Node inliningTarget, Object starargs) {
        return this.execute(null, inliningTarget, starargs);
    }

    @Specialization(guards={"isNoValue(starargs)"})
    static PKeyword[] convert(Object starargs) {
        return PKeyword.EMPTY_KEYWORDS;
    }

    @Specialization(guards={"!isNoValue(starargs)"})
    static PKeyword[] convert(VirtualFrame frame, Node inliningTarget, Object starargs, @Cached MappingToKeywordsNode convertNode, @Cached PRaiseNode raiseNode) {
        try {
            return convertNode.execute(frame, inliningTarget, starargs);
        }
        catch (SameDictKeyException e) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.GOT_MULTIPLE_VALUES_FOR_KEYWORD_ARG, e.getKey());
        }
        catch (NonMappingException e) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_ISNT_MAPPING, starargs);
        }
    }

    public static ExpandKeywordStarargsNode getUncached() {
        return ExpandKeywordStarargsNodeGen.getUncached();
    }
}

