/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.truffle.api.CompilerDirectives;

public class SSTUtils {
    public static void checkForbiddenArgs(ParserCallbacks parserCallbacks, SourceRange currentLocation, ArgumentsTy args) {
        if (args != null) {
            if (args.posOnlyArgs != null) {
                for (ArgTy arg : args.posOnlyArgs) {
                    SSTUtils.checkForbiddenName(parserCallbacks, currentLocation, arg.arg, ExprContextTy.Store);
                }
            }
            if (args.args != null) {
                for (ArgTy arg : args.args) {
                    SSTUtils.checkForbiddenName(parserCallbacks, currentLocation, arg.arg, ExprContextTy.Store);
                }
            }
            if (args.kwOnlyArgs != null) {
                for (ArgTy arg : args.kwOnlyArgs) {
                    SSTUtils.checkForbiddenName(parserCallbacks, currentLocation, arg.arg, ExprContextTy.Store);
                }
            }
            if (args.varArg != null) {
                SSTUtils.checkForbiddenName(parserCallbacks, currentLocation, args.varArg.arg, ExprContextTy.Store);
            }
            if (args.kwArg != null) {
                SSTUtils.checkForbiddenName(parserCallbacks, currentLocation, args.kwArg.arg, ExprContextTy.Store);
            }
        }
    }

    public static void checkForbiddenName(ParserCallbacks parserCallbacks, SourceRange currentLocation, String id, ExprContextTy context) {
        if (context == ExprContextTy.Store && id.equals("__debug__")) {
            throw parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, currentLocation, "cannot assign to __debug__");
        }
        if (context == ExprContextTy.Del && id.equals("__debug__")) {
            throw parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, currentLocation, "cannot delete __debug__");
        }
    }

    public static void checkSubscripter(ParserCallbacks parserCallbacks, ExprTy e) {
        block5: {
            block4: {
                if (!(e instanceof ExprTy.Constant)) break block4;
                switch (((ExprTy.Constant)e).value.kind) {
                    case NONE: 
                    case ELLIPSIS: 
                    case BOOLEAN: 
                    case LONG: 
                    case BIGINTEGER: 
                    case DOUBLE: 
                    case COMPLEX: 
                    case FROZENSET: {
                        break block5;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (!(e instanceof ExprTy.Set || e instanceof ExprTy.SetComp || e instanceof ExprTy.GeneratorExp || e instanceof ExprTy.Lambda)) {
                return;
            }
        }
        SSTUtils.warn(parserCallbacks, e, "'%s' object is not subscriptable; perhaps you missed a comma?", SSTUtils.inferType(e).getName());
    }

    public static void checkIndex(ParserCallbacks parserCallbacks, ExprTy e, ExprTy s) {
        PythonBuiltinClassType indexType;
        block6: {
            block5: {
                indexType = SSTUtils.inferType(s);
                if (indexType == null || indexType == PythonBuiltinClassType.Boolean || indexType == PythonBuiltinClassType.PInt || indexType == PythonBuiltinClassType.PSlice) {
                    return;
                }
                if (!(e instanceof ExprTy.Constant)) break block5;
                switch (((ExprTy.Constant)e).value.kind) {
                    case CODEPOINTS: 
                    case BYTES: 
                    case TUPLE: {
                        break block6;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (!(e instanceof ExprTy.Tuple || e instanceof ExprTy.List || e instanceof ExprTy.ListComp || e instanceof ExprTy.JoinedStr || e instanceof ExprTy.FormattedValue)) {
                return;
            }
        }
        SSTUtils.warn(parserCallbacks, e, "%s indices must be integers or slices, not %s; perhaps you missed a comma?", SSTUtils.inferType(e).getName(), indexType.getName());
    }

    public static void checkCompare(ParserCallbacks parserCallbacks, ExprTy.Compare node) {
        ExprTy leftExpr = node.left;
        boolean left = SSTUtils.checkIsArg(leftExpr);
        int n = node.ops == null ? 0 : node.ops.length;
        for (int i = 0; i < n; ++i) {
            CmpOpTy op = node.ops[i];
            ExprTy rightExpr = node.comparators[i];
            boolean right = SSTUtils.checkIsArg(rightExpr);
            if (!(op != CmpOpTy.Is && op != CmpOpTy.IsNot || right && left)) {
                ExprTy literal = !left ? leftExpr : rightExpr;
                SSTUtils.warn(parserCallbacks, node, op == CmpOpTy.Is ? "\"is\" with '%s' literal. Did you mean \"==\"?" : "\"is not\" with '%s' literal. Did you mean \"!=\"?", SSTUtils.inferType(literal).getName());
            }
            left = right;
            leftExpr = rightExpr;
        }
    }

    private static boolean checkIsArg(ExprTy e) {
        if (e instanceof ExprTy.Constant) {
            ConstantValue.Kind kind = ((ExprTy.Constant)e).value.kind;
            return kind == ConstantValue.Kind.NONE || kind == ConstantValue.Kind.BOOLEAN || kind == ConstantValue.Kind.ELLIPSIS;
        }
        return true;
    }

    public static void checkCaller(ParserCallbacks parserCallbacks, ExprTy e) {
        if (e instanceof ExprTy.Constant || e instanceof ExprTy.Tuple || e instanceof ExprTy.List || e instanceof ExprTy.ListComp || e instanceof ExprTy.Dict || e instanceof ExprTy.DictComp || e instanceof ExprTy.Set || e instanceof ExprTy.SetComp || e instanceof ExprTy.GeneratorExp || e instanceof ExprTy.JoinedStr || e instanceof ExprTy.FormattedValue) {
            SSTUtils.warn(parserCallbacks, e, "'%s' object is not callable; perhaps you missed a comma?", SSTUtils.inferType(e).getName());
        }
    }

    public static PythonBuiltinClassType inferType(ExprTy e) {
        if (e instanceof ExprTy.Tuple) {
            return PythonBuiltinClassType.PTuple;
        }
        if (e instanceof ExprTy.List || e instanceof ExprTy.ListComp) {
            return PythonBuiltinClassType.PList;
        }
        if (e instanceof ExprTy.Dict || e instanceof ExprTy.DictComp) {
            return PythonBuiltinClassType.PDict;
        }
        if (e instanceof ExprTy.Set || e instanceof ExprTy.SetComp) {
            return PythonBuiltinClassType.PSet;
        }
        if (e instanceof ExprTy.GeneratorExp) {
            return PythonBuiltinClassType.PGenerator;
        }
        if (e instanceof ExprTy.Lambda) {
            return PythonBuiltinClassType.PFunction;
        }
        if (e instanceof ExprTy.JoinedStr || e instanceof ExprTy.FormattedValue) {
            return PythonBuiltinClassType.PString;
        }
        if (e instanceof ExprTy.Constant) {
            switch (((ExprTy.Constant)e).value.kind) {
                case NONE: {
                    return PythonBuiltinClassType.PNone;
                }
                case ELLIPSIS: {
                    return PythonBuiltinClassType.PEllipsis;
                }
                case BOOLEAN: {
                    return PythonBuiltinClassType.Boolean;
                }
                case DOUBLE: {
                    return PythonBuiltinClassType.PFloat;
                }
                case COMPLEX: {
                    return PythonBuiltinClassType.PComplex;
                }
                case LONG: 
                case BIGINTEGER: {
                    return PythonBuiltinClassType.PInt;
                }
                case CODEPOINTS: {
                    return PythonBuiltinClassType.PString;
                }
                case BYTES: {
                    return PythonBuiltinClassType.PBytes;
                }
                case TUPLE: {
                    return PythonBuiltinClassType.PTuple;
                }
                case FROZENSET: {
                    return PythonBuiltinClassType.PFrozenSet;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)("Invalid ConstantValue kind: " + String.valueOf((Object)((ExprTy.Constant)e).value.kind)));
        }
        return null;
    }

    private static void warn(ParserCallbacks parserCallbacks, SSTNode node, String message, Object ... arguments) {
        parserCallbacks.onWarning(ParserCallbacks.WarningType.Syntax, node.getSourceRange(), message, arguments);
    }
}

