/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.foreign.ForeignObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.foreign.ForeignObjectBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ForeignObject})
public final class ForeignObjectBuiltins
extends PythonBuiltins {
    public static TpSlots SLOTS = ForeignObjectBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignObjectBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static String asJavaPrefixedMethod(String prefix, String member) {
        return prefix + member.substring(0, 1).toUpperCase() + member.substring(1);
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        @Node.Child
        private ObjectNodes.DefaultObjectReprNode defaultReprNode;

        ReprNode() {
        }

        @Override
        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                if (this.getContext().getEnv().isHostObject(object)) {
                    boolean isMetaObject = lib.isMetaObject(object);
                    Object metaObject = null;
                    if (isMetaObject) {
                        metaObject = object;
                    } else if (lib.hasMetaObject(object)) {
                        metaObject = lib.getMetaObject(object);
                    }
                    if (metaObject != null) {
                        TruffleString displayName = this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(metaObject)), PythonUtils.TS_ENCODING);
                        return StringUtils.simpleTruffleStringFormatUncached("<%s[%s] at 0x%s>", isMetaObject ? "JavaClass" : "JavaObject", displayName, PythonAbstractObject.systemHashCodeAsHexString(object));
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            if (this.defaultReprNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.defaultReprNode = (ObjectNodes.DefaultObjectReprNode)this.insert(ObjectNodes.DefaultObjectReprNode.create());
            }
            return this.defaultReprNode.executeCached((Frame)frame, object);
        }
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode;
        private static final TpSlot FOREIGN_REPR = SLOTS.tp_repr();

        StrNode() {
        }

        @Specialization
        Object str(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached PyObjectReprAsObjectNode reprNode, @CachedLibrary(limit="3") InteropLibrary lib, @Cached ObjectNodes.DefaultObjectReprNode defaultReprNode, @Cached InlinedBranchProfile isIterator, @Cached InlinedBranchProfile defaultCase) {
            TpSlots slots = getSlots.execute(inliningTarget, object);
            if (slots.tp_repr() != FOREIGN_REPR) {
                return reprNode.execute((Frame)frame, inliningTarget, object);
            }
            if (lib.isIterator(object)) {
                isIterator.enter(inliningTarget);
                return defaultReprNode.execute((Frame)frame, inliningTarget, object);
            }
            defaultCase.enter(inliningTarget);
            return this.defaultConversion(frame, lib, object);
        }

        protected TruffleString.SwitchEncodingNode getSwitchEncodingNode() {
            if (this.switchEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.switchEncodingNode = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
            }
            return this.switchEncodingNode;
        }

        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                return this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(object)), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"toDisplayString result not convertible to String");
            }
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        DirNode() {
        }

        @Specialization
        protected Object doIt(VirtualFrame frame, Object object, @Bind Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @CachedLibrary(limit="3") InteropLibrary arrayInterop, @CachedLibrary(limit="3") InteropLibrary stringInterop, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached GilNode gil, @Cached InlinedConditionProfile profile, @Cached GetClassNode getClassNode, @Cached TypeBuiltins.DirNode typeDirNode, @Cached SetNodes.AddNode addNode, @Cached ListBuiltins.ListSortNode sortNode, @Cached SetNodes.ConstructSetNode constructSetNode, @Cached ListNodes.ConstructListNode constructListNode) {
            Object pythonClass = getClassNode.execute(inliningTarget, object);
            PSet attributes = constructSetNode.execute((Frame)frame, typeDirNode.execute(frame, pythonClass));
            if (profile.profile(inliningTarget, lib.hasMembers(object))) {
                Object members;
                gil.release(true);
                try {
                    members = lib.getMembers(object);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)"foreign object claims to have members, but does not return them");
                }
                finally {
                    gil.acquire();
                }
                try {
                    long size = arrayInterop.getArraySize(members);
                    int i = 0;
                    while ((long)i < size) {
                        TruffleString memberString = stringInterop.asTruffleString(arrayInterop.readArrayElement(members, (long)i));
                        memberString = switchEncodingNode.execute((AbstractTruffleString)memberString, PythonUtils.TS_ENCODING);
                        addNode.execute((Frame)frame, attributes, memberString);
                        ++i;
                    }
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            PList list = constructListNode.execute((Frame)frame, attributes);
            sortNode.execute(frame, list);
            return list;
        }
    }

    @Slot(value=Slot.SlotKind.tp_setattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    static abstract class SetattrNode
    extends TpSlotSetAttr.SetAttrBuiltinNode {
        SetattrNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void doSet(Object object, Object key, Object value, @Bind Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached CastToJavaStringNode castToString, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PRaiseNode raiseNode) {
            block13: {
                String member;
                gil.release(true);
                try {
                    member = castToString.execute(key);
                }
                catch (CannotCastException e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, key);
                }
                try {
                    lib.writeMember(object, member, value);
                    return;
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    if (!PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.EmulateJython).booleanValue()) break block13;
                    try {
                        String setter;
                        if (PythonContext.get(inliningTarget).getEnv().isHostObject(object) && lib.isMemberInvocable(object, setter = ForeignObjectBuiltins.asJavaPrefixedMethod("set", member))) {
                            lib.invokeMember(object, setter, new Object[]{value});
                            return;
                        }
                    }
                    catch (ArityException | UnknownIdentifierException | UnsupportedMessageException throwable) {
                        // empty catch block
                    }
                }
                catch (UnsupportedTypeException e) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.INVALID_TYPE_FOR_S, key);
                }
                finally {
                    gil.acquire();
                }
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, key);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void doDelete(Object object, Object key, PNone value, @Bind Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached CastToJavaStringNode castToString, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PRaiseNode raiseNode) {
            gil.release(true);
            try {
                lib.removeMember(object, castToString.execute(key));
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, key);
            }
            finally {
                gil.acquire();
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class})
    public static abstract class ForeignGetattrNode
    extends Node {
        public abstract Object execute(Node var1, Object var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doIt(Node inliningTarget, Object object, Object memberObj, @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") InteropLibrary read, @Cached(inline=false) CastToJavaStringNode castToString, @Cached(inline=false) GilNode gil, @Cached(inline=false) PForeignToPTypeNode toPythonNode, @Cached PRaiseNode raiseNode) {
            gil.release(true);
            try {
                String getter;
                String member;
                try {
                    member = castToString.execute(memberObj);
                }
                catch (CannotCastException e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, memberObj);
                }
                if (read.isMemberReadable(object, member)) {
                    Object e = toPythonNode.executeConvert(read.readMember(object, member));
                    return e;
                }
                if (PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.EmulateJython).booleanValue() && PythonContext.get(inliningTarget).getEnv().isHostObject(object) && read.isMemberInvocable(object, getter = ForeignObjectBuiltins.asJavaPrefixedMethod("get", member))) {
                    try {
                        Object object2 = toPythonNode.executeConvert(read.invokeMember(object, getter, new Object[0]));
                        return object2;
                    }
                    catch (UnsupportedTypeException unsupportedTypeException) {}
                }
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException throwable) {
            }
            finally {
                gil.acquire();
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, memberObj);
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetAttributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        GetAttributeNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object name, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAttrError, @Cached ForeignGetattrNode foreignGetattrNode) {
            try {
                return objectGetattrNode.execute(frame, self, name);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, isAttrError);
                return foreignGetattrNode.execute(inliningTarget, self, name);
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        HashNode() {
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
        static long hash(Object self, @CachedLibrary(value="self") InteropLibrary library) {
            if (library.hasIdentity(self)) {
                try {
                    return library.identityHashCode(self);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return HashNode.hashCodeBoundary(self);
        }

        @CompilerDirectives.TruffleBoundary
        private static int hashCodeBoundary(Object self) {
            return self.hashCode();
        }
    }
}

