/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.contextvars.Hamt;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

public class PContextVarsContext
extends PythonBuiltinObject {
    Hamt contextVarValues;
    private PContextVarsContext previousContext = null;

    public void enter(Node inliningTarget, PythonContext.PythonThreadState threadState, PRaiseNode raise) {
        if (this.previousContext != null) {
            throw raise.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_ENTER_CONTEXT_ALREADY_ENTERED, this);
        }
        this.previousContext = threadState.getContextVarsContext(inliningTarget);
        assert (this.previousContext != null) : "ThreadState had null Context. This should not happen";
        threadState.setContextVarsContext(this);
    }

    public void leave(PythonContext.PythonThreadState threadState) {
        assert (threadState.getContextVarsContext(null) == this) : "leaving a context which is not currently entered";
        assert (this.previousContext != null) : "entered context has no previous context";
        threadState.setContextVarsContext(this.previousContext);
        this.previousContext = null;
    }

    public PContextVarsContext(Object cls, Shape instanceShape) {
        this(new Hamt(), cls, instanceShape);
    }

    public PContextVarsContext(PContextVarsContext original, Object cls, Shape instanceShape) {
        this(original.contextVarValues, cls, instanceShape);
    }

    private PContextVarsContext(Hamt contextVarValues, Object cls, Shape instanceShape) {
        super(cls, instanceShape);
        this.contextVarValues = contextVarValues;
    }
}

