/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.zlib.JavaZlibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibCompObject;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;

public final class JavaCompress
extends JavaZlibCompObject {
    final CompressStream stream;
    final int level;
    final int strategy;

    @CompilerDirectives.TruffleBoundary
    private static CompressStream createStream(int level, int wbits) {
        Deflater def;
        GZIPCompressStream stream = null;
        ByteArrayOutputStream out = null;
        if (wbits > 24 && wbits <= 31) {
            try {
                out = new ByteArrayOutputStream();
                stream = new GZIPCompressStream(out);
                def = stream.getDeflater();
                def.setLevel(level);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            def = new Deflater(level, wbits < 0);
        }
        return new CompressStream(def, out, stream);
    }

    public JavaCompress(Object cls, Shape instanceShape, int level, int wbits, int strategy, byte[] zdict) {
        super(cls, instanceShape, wbits, zdict);
        this.stream = JavaCompress.createStream(level, wbits);
        this.level = level;
        this.strategy = strategy;
    }

    @CompilerDirectives.TruffleBoundary
    protected void setDeflaterInput(byte[] data, int length) {
        this.canCopy = this.inputData == null;
        this.inputData = data;
        this.inputLen = length;
        this.stream.deflater.setInput(data, 0, length);
    }

    @CompilerDirectives.TruffleBoundary
    protected ZLibCompObject copy() {
        assert (this.canCopy());
        JavaCompress obj = PFactory.createJavaZLibCompObjectCompress(PythonLanguage.get(null), this.level, this.wbits, this.strategy, this.zdict);
        Deflater deflater = obj.stream.deflater();
        obj.setStrategy();
        obj.setDictionary();
        if (this.inputData != null) {
            obj.setDeflaterInput(this.inputData, this.inputLen);
            deflater.deflate(new byte[this.inputLen]);
        }
        return obj;
    }

    @CompilerDirectives.TruffleBoundary
    protected void setStrategy() {
        this.stream.deflater.setStrategy(this.strategy);
    }

    protected void setDictionary() {
        if (this.getZdict().length > 0) {
            this.stream.deflater.setDictionary(this.getZdict());
        }
    }

    private static void compress(CompressStream stream, ByteArrayOutputStream out, int mode) {
        byte[] result = new byte[16384];
        int bytesWritten = result.length;
        while (bytesWritten == result.length) {
            bytesWritten = stream.deflater.deflate(result, 0, result.length, mode);
            out.write(result, 0, bytesWritten);
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected byte[] compress(int mode) {
        if (mode == 4) {
            return this.compressFinish();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JavaCompress.compress(this.stream, baos, mode);
        return baos.toByteArray();
    }

    @CompilerDirectives.TruffleBoundary
    private static void compressFinish(CompressStream stream, ByteArrayOutputStream out) {
        stream.deflater.finish();
        JavaCompress.compress(stream, out, 2);
        stream.deflater.end();
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] compressFinish() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JavaCompress.compressFinish(this.stream, baos);
        this.setUninitialized();
        return baos.toByteArray();
    }

    @CompilerDirectives.TruffleBoundary
    protected static byte[] compressFinish(byte[] bytes, int length, int level, int wbits, Node node) {
        CompressStream stream = JavaCompress.createStream(level, wbits);
        stream.deflater.setInput(bytes, 0, length);
        if (stream.stream != null) {
            try {
                stream.stream.finish();
                return stream.out.toByteArray();
            }
            catch (ZipException ze) {
                throw PRaiseNode.raiseStatic(node, PythonErrorType.ZLibError, ze);
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        Deflater compresser = stream.deflater();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        compresser.setInput(bytes, 0, length);
        compresser.finish();
        byte[] resultArray = new byte[16384];
        while (!compresser.finished()) {
            int howmany = compresser.deflate(resultArray);
            baos.write(resultArray, 0, howmany);
        }
        compresser.end();
        return baos.toByteArray();
    }

    private static class GZIPCompressStream
    extends GZIPOutputStream {
        public GZIPCompressStream(OutputStream out) throws IOException {
            super(out);
        }

        public Deflater getDeflater() {
            return this.def;
        }
    }

    private record CompressStream(Deflater deflater, ByteArrayOutputStream out, GZIPCompressStream stream) {
    }
}

