/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextHashBuiltins {

    static abstract class _Py_HashBytes
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _Py_HashBytes() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static long doI(Object value, long size, @Cached CStructAccess.ReadByteNode readNode, @Cached TruffleString.FromByteArrayNode toString, @Cached TruffleString.HashCodeNode hashNode) {
            byte[] array = readNode.readByteArray(value, (int)size);
            TruffleString string = toString.execute(array, TruffleString.Encoding.US_ASCII, false);
            return PyObjectHashNode.hash(string, hashNode);
        }
    }

    static abstract class GraalPyPrivate_HashDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_HashDouble() {
        }

        @Specialization
        long doFinite(double value) {
            assert (!Double.isNaN(value));
            return PyObjectHashNode.hash(value);
        }
    }

    static abstract class GraalPyPrivate_HashConstant
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_HashConstant() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static long doI(int idx) {
            switch (idx) {
                case 0: {
                    return PyObjectHashNode.hash(Double.POSITIVE_INFINITY);
                }
                case 1: {
                    return 0x1FFFFFFFFFFFFFFFL;
                }
                case 2: {
                    return 1000003L;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    static abstract class GraalPyPrivate_Hash_InitSecret
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Hash_InitSecret() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object get(Object secretPtr, @Cached CStructAccess.WriteByteNode writeNode) {
            writeNode.writeByteArray(secretPtr, this.getContext().getHashSecret());
            return PNone.NO_VALUE;
        }
    }
}

