/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.objects.Undefined;

public enum WebAssemblyValueType {
    i32(false),
    i64(false),
    f32(false),
    f64(false),
    v128(false),
    anyfunc(true),
    externref(true);

    private final boolean reference;

    private WebAssemblyValueType(boolean reference) {
        this.reference = reference;
    }

    public boolean isReference() {
        return this.reference;
    }

    public Object getDefaultValue(JSRealm realm) {
        return switch (this.ordinal()) {
            case 0 -> Integer.valueOf(0);
            case 1 -> Long.valueOf(0L);
            case 2 -> Float.valueOf(0.0f);
            case 3 -> Double.valueOf(0.0);
            case 5 -> realm.getWasmRefNull();
            case 6 -> Undefined.instance;
            default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)this);
        };
    }

    public static WebAssemblyValueType lookupType(String type) {
        return switch (type) {
            case "i32" -> i32;
            case "i64" -> i64;
            case "f32" -> f32;
            case "f64" -> f64;
            case "v128" -> v128;
            case "anyfunc" -> anyfunc;
            case "externref" -> externref;
            default -> null;
        };
    }
}

