/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalInstantNode
extends JavaScriptBaseNode {
    protected ToTemporalInstantNode() {
    }

    public abstract JSTemporalInstantObject execute(Object var1);

    @Specialization
    public JSTemporalInstantObject toTemporalDateTime(Object item, @Cached IsObjectNode isObjectNode, @Cached JSToPrimitiveNode toPrimitiveNode, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedBranchProfile errorBranch) {
        Object primitiveItem;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            BigInt nanoseconds = null;
            if (item instanceof JSTemporalInstantObject) {
                JSTemporalInstantObject instant = (JSTemporalInstantObject)((Object)item);
                nanoseconds = instant.getNanoseconds();
            }
            if (item instanceof JSTemporalZonedDateTimeObject) {
                JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)((Object)item);
                nanoseconds = zonedDateTime.getNanoseconds();
            }
            if (nanoseconds != null) {
                return JSTemporalInstant.create(this.getLanguage().getJSContext(), this.getRealm(), nanoseconds);
            }
            primitiveItem = toPrimitiveNode.executeHintString(item);
        } else {
            primitiveItem = item;
        }
        if (primitiveItem instanceof TruffleString) {
            TruffleString string = (TruffleString)primitiveItem;
            BigInt epochNanoseconds = TemporalUtil.parseTemporalInstant(string);
            return JSTemporalInstant.create(this.getLanguage().getJSContext(), this.getRealm(), epochNanoseconds);
        }
        errorBranch.enter((Node)this);
        throw Errors.createTypeErrorNotAString(primitiveItem);
    }
}

