/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.util.FirebirdSupportInfo;

public final class GetTypeInfo {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(18, DbMetadataMediator.datatypeCoder).at(0).simple(448, 31, "TYPE_NAME", "TYPEINFO").addField().at(1).simple(496, 0, "DATA_TYPE", "TYPEINFO").addField().at(2).simple(496, 0, "PRECISION", "TYPEINFO").addField().at(3).simple(449, 1, "LITERAL_PREFIX", "TYPEINFO").addField().at(4).simple(449, 1, "LITERAL_SUFFIX", "TYPEINFO").addField().at(5).simple(449, 31, "CREATE_PARAMS", "TYPEINFO").addField().at(6).simple(500, 0, "NULLABLE", "TYPEINFO").addField().at(7).simple(452, 1, "CASE_SENSITIVE", "TYPEINFO").addField().at(8).simple(500, 0, "SEARCHABLE", "TYPEINFO").addField().at(9).simple(452, 1, "UNSIGNED_ATTRIBUTE", "TYPEINFO").addField().at(10).simple(452, 1, "FIXED_PREC_SCALE", "TYPEINFO").addField().at(11).simple(452, 1, "AUTO_INCREMENT", "TYPEINFO").addField().at(12).simple(449, 31, "LOCAL_TYPE_NAME", "TYPEINFO").addField().at(13).simple(500, 0, "MINIMUM_SCALE", "TYPEINFO").addField().at(14).simple(500, 0, "MAXIMUM_SCALE", "TYPEINFO").addField().at(15).simple(496, 0, "SQL_DATA_TYPE", "TYPEINFO").addField().at(16).simple(497, 0, "SQL_DATETIME_SUB", "TYPEINFO").addField().at(17).simple(496, 0, "NUM_PREC_RADIX", "TYPEINFO").addField().toRowDescriptor();
    private final DbMetadataMediator mediator;

    private GetTypeInfo(DbMetadataMediator mediator) {
        this.mediator = mediator;
    }

    public ResultSet getTypeInfo() throws SQLException {
        FirebirdSupportInfo firebirdSupportInfo = this.mediator.getFirebirdSupportInfo();
        int blobTypePred = firebirdSupportInfo.supportsFullSearchableBlobs() ? 3 : 2;
        ArrayList<RowValue> rows = new ArrayList<RowValue>(23);
        if (firebirdSupportInfo.supportsDecfloat()) {
            rows.add(GetTypeInfo.row("DECFLOAT", -6001, 34, null, null, "precision", false, 3, false, false, 0, 32762, 10));
        }
        rows.add(GetTypeInfo.row("BIGINT", -5, 19, null, null, null, false, 3, false, true, 0, 580, 10));
        rows.add(GetTypeInfo.row("BLOB SUB_TYPE BINARY", -4, 0, "x'", "'", null, true, blobTypePred, true, true, 0, 520, 10));
        rows.add(GetTypeInfo.row("VARCHAR", -3, 32765, "x'", "'", "length", true, 3, true, true, 0, 448, 10));
        rows.add(GetTypeInfo.row("CHAR", -2, Short.MAX_VALUE, "x'", "'", "length", true, 3, true, true, 0, 452, 10));
        rows.add(GetTypeInfo.row("BLOB SUB_TYPE TEXT", -1, 0, "'", "'", null, true, blobTypePred, true, true, 0, 520, 10));
        rows.add(GetTypeInfo.row("CHAR", 1, Short.MAX_VALUE, "'", "'", "length", true, 3, true, true, 0, 452, 10));
        int maxDecimalPrecision = firebirdSupportInfo.maxDecimalPrecision();
        rows.add(GetTypeInfo.row("NUMERIC", 2, maxDecimalPrecision, null, null, "precision,scale", false, 3, false, true, maxDecimalPrecision, 580, 10));
        if (firebirdSupportInfo.supportsInt128()) {
            rows.add(GetTypeInfo.row("INT128", 2, 38, null, null, null, false, 3, false, true, 0, 32752, 10));
        }
        rows.add(GetTypeInfo.row("DECIMAL", 3, maxDecimalPrecision, null, null, "precision,scale", false, 3, false, true, maxDecimalPrecision, 580, 10));
        rows.add(GetTypeInfo.row("INTEGER", 4, 10, null, null, null, false, 3, false, true, 0, 496, 10));
        rows.add(GetTypeInfo.row("SMALLINT", 5, 5, null, null, null, false, 3, false, true, 0, 500, 10));
        boolean supportsFloatBinaryPrecision = firebirdSupportInfo.supportsFloatBinaryPrecision();
        int floatPrecision = supportsFloatBinaryPrecision ? 24 : 7;
        rows.add(GetTypeInfo.row("FLOAT", 6, floatPrecision, null, null, null, false, 3, false, false, 0, 482, supportsFloatBinaryPrecision ? 2 : 10));
        int doublePrecision = supportsFloatBinaryPrecision ? 53 : 15;
        rows.add(GetTypeInfo.row("DOUBLE PRECISION", 8, doublePrecision, null, null, null, false, 3, false, false, 0, 480, supportsFloatBinaryPrecision ? 2 : 10));
        rows.add(GetTypeInfo.row("VARCHAR", 12, 32765, "'", "'", "length", true, 3, true, true, 0, 448, 10));
        if (firebirdSupportInfo.supportsBoolean()) {
            rows.add(GetTypeInfo.row("BOOLEAN", 16, 1, null, null, null, false, 2, true, true, 0, 32764, 2));
        }
        rows.add(GetTypeInfo.row("DATE", 91, 10, "date'", "'", null, false, 3, true, true, 0, 570, 10));
        rows.add(GetTypeInfo.row("TIME", 92, 13, "time'", "'", null, false, 3, true, true, 0, 560, 10));
        rows.add(GetTypeInfo.row("TIMESTAMP", 93, 24, "timestamp'", "'", null, false, 3, true, true, 0, 510, 10));
        rows.add(GetTypeInfo.row("ARRAY", 1111, 0, null, null, null, true, 0, true, true, 0, 540, 10));
        rows.add(GetTypeInfo.row("BLOB SUB_TYPE <0", 2004, 0, null, null, null, true, 0, true, true, 0, 520, 10));
        if (firebirdSupportInfo.supportsTimeZones()) {
            rows.add(GetTypeInfo.row("TIME WITH TIME ZONE", 2013, 19, "time'", "'", null, false, 3, true, true, 0, 32756, 10));
            rows.add(GetTypeInfo.row("TIMESTAMP WITH TIME ZONE", 2014, 30, "timestamp'", "'", null, false, 3, true, true, 0, 32754, 10));
        }
        return new FBResultSet(ROW_DESCRIPTOR, rows);
    }

    private static RowValue row(String typeName, int jdbcType, int precision, String literalPrefix, String literalSuffix, String createParams, boolean caseSensitive, int searchable, boolean unsigned, boolean fixedPrecScale, int maxScale, int sqlDataType, int numPrecRadix) {
        DatatypeCoder coder = DbMetadataMediator.datatypeCoder;
        return RowValue.of(ROW_DESCRIPTOR, (byte[][])new byte[][]{GetTypeInfo.getBytes(typeName), coder.encodeInt(jdbcType), coder.encodeInt(precision), GetTypeInfo.getBytes(literalPrefix), GetTypeInfo.getBytes(literalSuffix), GetTypeInfo.getBytes(createParams), coder.encodeShort(1), GetTypeInfo.getCharBoolean(caseSensitive), coder.encodeShort(searchable), GetTypeInfo.getCharBoolean(unsigned), GetTypeInfo.getCharBoolean(fixedPrecScale), GetTypeInfo.getCharBoolean(false), null, coder.encodeShort(0), coder.encodeShort(maxScale), coder.encodeInt(sqlDataType), null, coder.encodeInt(numPrecRadix)});
    }

    private static byte[] getBytes(String value) {
        return value != null ? DbMetadataMediator.datatypeCoder.encodeString(value) : null;
    }

    private static byte[] getCharBoolean(boolean booleanValue) {
        byte[] byArray;
        if (booleanValue) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 84;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 70;
        }
        return byArray;
    }

    public static GetTypeInfo create(DbMetadataMediator mediator) {
        return new GetTypeInfo(mediator);
    }
}

