/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.ioresource.BaseInputResource;

public class FileInputResource
extends BaseInputResource {
    private final Path inputFile;

    public FileInputResource(Path filePath) throws IOException {
        this.inputFile = Objects.requireNonNull(filePath, "No file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable(this.inputFile)) {
            IOException e = new IOException("Cannot read file, <%s>".formatted(this.inputFile));
            throw e;
        }
    }

    @Override
    public InputStream openNewInputStream() throws IOException {
        InputStream reader = Files.newInputStream(this.inputFile, new OpenOption[0]);
        return reader;
    }

    public String toString() {
        return this.inputFile.toString();
    }
}

